/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.EventStreamWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetEventSize;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The event stream is a widget version of the stream of events on the Event Stream view. Only available on FREE layout dashboards.")
@JsonPropertyOrder(value={"event_size", "query", "tags_execution", "time", "title", "title_align", "title_size", "type"})
public class EventStreamWidgetDefinition {
    public static final String JSON_PROPERTY_EVENT_SIZE = "event_size";
    private WidgetEventSize eventSize;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_TAGS_EXECUTION = "tags_execution";
    private String tagsExecution;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private EventStreamWidgetDefinitionType type = EventStreamWidgetDefinitionType.EVENT_STREAM;

    public EventStreamWidgetDefinition eventSize(WidgetEventSize eventSize) {
        this.eventSize = eventSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="event_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetEventSize getEventSize() {
        return this.eventSize;
    }

    public void setEventSize(WidgetEventSize eventSize) {
        this.eventSize = eventSize;
    }

    public EventStreamWidgetDefinition query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="Query to filter the event stream with.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public EventStreamWidgetDefinition tagsExecution(String tagsExecution) {
        this.tagsExecution = tagsExecution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The execution method for multi-value filters. Can be either and or or.")
    @JsonProperty(value="tags_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTagsExecution() {
        return this.tagsExecution;
    }

    public void setTagsExecution(String tagsExecution) {
        this.tagsExecution = tagsExecution;
    }

    public EventStreamWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public EventStreamWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public EventStreamWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public EventStreamWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public EventStreamWidgetDefinition type(EventStreamWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventStreamWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(EventStreamWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventStreamWidgetDefinition eventStreamWidgetDefinition = (EventStreamWidgetDefinition)o;
        return Objects.equals((Object)this.eventSize, (Object)eventStreamWidgetDefinition.eventSize) && Objects.equals(this.query, eventStreamWidgetDefinition.query) && Objects.equals(this.tagsExecution, eventStreamWidgetDefinition.tagsExecution) && Objects.equals(this.time, eventStreamWidgetDefinition.time) && Objects.equals(this.title, eventStreamWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)eventStreamWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, eventStreamWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)eventStreamWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventSize, this.query, this.tagsExecution, this.time, this.title, this.titleAlign, this.titleSize, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventStreamWidgetDefinition {\n");
        sb.append("    eventSize: ").append(this.toIndentedString((Object)this.eventSize)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    tagsExecution: ").append(this.toIndentedString(this.tagsExecution)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

