/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.DashboardLayoutType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Dashboard definition.")
@JsonPropertyOrder(value={"author_handle", "created_at", "description", "id", "is_read_only", "layout_type", "modified_at", "title", "url"})
public class DashboardSummaryDashboards {
    public static final String JSON_PROPERTY_AUTHOR_HANDLE = "author_handle";
    private String authorHandle;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_READ_ONLY = "is_read_only";
    private Boolean isReadOnly;
    public static final String JSON_PROPERTY_LAYOUT_TYPE = "layout_type";
    private DashboardLayoutType layoutType;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public DashboardSummaryDashboards authorHandle(String authorHandle) {
        this.authorHandle = authorHandle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the dashboard author.")
    @JsonProperty(value="author_handle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorHandle() {
        return this.authorHandle;
    }

    public void setAuthorHandle(String authorHandle) {
        this.authorHandle = authorHandle;
    }

    public DashboardSummaryDashboards createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Creation date of the dashboard.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DashboardSummaryDashboards description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the dashboard.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DashboardSummaryDashboards id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dashboard identifier.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DashboardSummaryDashboards isReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this dashboard is read-only. If True, only the author and admins can make changes to it.")
    @JsonProperty(value="is_read_only")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public DashboardSummaryDashboards layoutType(DashboardLayoutType layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="layout_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DashboardLayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(DashboardLayoutType layoutType) {
        this.layoutType = layoutType;
    }

    public DashboardSummaryDashboards modifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Modification date of the dashboard.")
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public DashboardSummaryDashboards title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the dashboard.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DashboardSummaryDashboards url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the dashboard.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardSummaryDashboards dashboardSummaryDashboards = (DashboardSummaryDashboards)o;
        return Objects.equals(this.authorHandle, dashboardSummaryDashboards.authorHandle) && Objects.equals(this.createdAt, dashboardSummaryDashboards.createdAt) && Objects.equals(this.description, dashboardSummaryDashboards.description) && Objects.equals(this.id, dashboardSummaryDashboards.id) && Objects.equals(this.isReadOnly, dashboardSummaryDashboards.isReadOnly) && Objects.equals((Object)this.layoutType, (Object)dashboardSummaryDashboards.layoutType) && Objects.equals(this.modifiedAt, dashboardSummaryDashboards.modifiedAt) && Objects.equals(this.title, dashboardSummaryDashboards.title) && Objects.equals(this.url, dashboardSummaryDashboards.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorHandle, this.createdAt, this.description, this.id, this.isReadOnly, this.layoutType, this.modifiedAt, this.title, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardSummaryDashboards {\n");
        sb.append("    authorHandle: ").append(this.toIndentedString(this.authorHandle)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isReadOnly: ").append(this.toIndentedString(this.isReadOnly)).append("\n");
        sb.append("    layoutType: ").append(this.toIndentedString((Object)this.layoutType)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

