/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.ApiKey;
import com.datadog.api.v1.client.model.ApiKeyListResponse;
import com.datadog.api.v1.client.model.ApiKeyResponse;
import com.datadog.api.v1.client.model.ApplicationKey;
import com.datadog.api.v1.client.model.ApplicationKeyListResponse;
import com.datadog.api.v1.client.model.ApplicationKeyResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class KeyManagementApi {
    private ApiClient apiClient;

    public KeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<ApiKeyResponse> createAPIKeyWithHttpInfo(ApiKey body) throws ApiException {
        ApiKey localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAPIKey");
        }
        String localVarPath = "/api/v1/api_key";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApiKeyResponse> localVarReturnType = new GenericType<ApiKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.createAPIKey", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateAPIKeyRequest createAPIKey() throws ApiException {
        return new APIcreateAPIKeyRequest();
    }

    private ApiResponse<ApplicationKeyResponse> createApplicationKeyWithHttpInfo(ApplicationKey body) throws ApiException {
        ApplicationKey localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApplicationKey");
        }
        String localVarPath = "/api/v1/application_key";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.createApplicationKey", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateApplicationKeyRequest createApplicationKey() throws ApiException {
        return new APIcreateApplicationKeyRequest();
    }

    private ApiResponse<ApiKeyResponse> deleteAPIKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteAPIKey");
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApiKeyResponse> localVarReturnType = new GenericType<ApiKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteAPIKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIdeleteAPIKeyRequest deleteAPIKey(String key) throws ApiException {
        return new APIdeleteAPIKeyRequest(key);
    }

    private ApiResponse<ApplicationKeyResponse> deleteApplicationKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteApplicationKey");
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteApplicationKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIdeleteApplicationKeyRequest deleteApplicationKey(String key) throws ApiException {
        return new APIdeleteApplicationKeyRequest(key);
    }

    private ApiResponse<ApiKeyResponse> getAPIKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getAPIKey");
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApiKeyResponse> localVarReturnType = new GenericType<ApiKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.getAPIKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetAPIKeyRequest getAPIKey(String key) throws ApiException {
        return new APIgetAPIKeyRequest(key);
    }

    private ApiResponse<ApplicationKeyResponse> getApplicationKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getApplicationKey");
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.getApplicationKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetApplicationKeyRequest getApplicationKey(String key) throws ApiException {
        return new APIgetApplicationKeyRequest(key);
    }

    private ApiResponse<ApiKeyListResponse> listAPIKeysWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/api_key";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAPIKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApiKeyListResponse> localVarReturnType = new GenericType<ApiKeyListResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listAPIKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistAPIKeysRequest listAPIKeys() throws ApiException {
        return new APIlistAPIKeysRequest();
    }

    private ApiResponse<ApplicationKeyListResponse> listApplicationKeysWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/application_key";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listApplicationKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyListResponse> localVarReturnType = new GenericType<ApplicationKeyListResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listApplicationKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistApplicationKeysRequest listApplicationKeys() throws ApiException {
        return new APIlistApplicationKeysRequest();
    }

    private ApiResponse<ApiKeyResponse> updateAPIKeyWithHttpInfo(String key, ApiKey body) throws ApiException {
        ApiKey localVarPostBody = body;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateAPIKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAPIKey");
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApiKeyResponse> localVarReturnType = new GenericType<ApiKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateAPIKey", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateAPIKeyRequest updateAPIKey(String key) throws ApiException {
        return new APIupdateAPIKeyRequest(key);
    }

    private ApiResponse<ApplicationKeyResponse> updateApplicationKeyWithHttpInfo(String key, ApplicationKey body) throws ApiException {
        ApplicationKey localVarPostBody = body;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationKey");
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateApplicationKey", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateApplicationKeyRequest updateApplicationKey(String key) throws ApiException {
        return new APIupdateApplicationKeyRequest(key);
    }

    public class APIupdateApplicationKeyRequest {
        private String key;
        private ApplicationKey body;

        private APIupdateApplicationKeyRequest(String key) {
            this.key = key;
        }

        public APIupdateApplicationKeyRequest body(ApplicationKey body) {
            this.body = body;
            return this;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.updateApplicationKeyWithHttpInfo(this.key, this.body);
        }
    }

    public class APIupdateAPIKeyRequest {
        private String key;
        private ApiKey body;

        private APIupdateAPIKeyRequest(String key) {
            this.key = key;
        }

        public APIupdateAPIKeyRequest body(ApiKey body) {
            this.body = body;
            return this;
        }

        public ApiKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApiKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.updateAPIKeyWithHttpInfo(this.key, this.body);
        }
    }

    public class APIlistApplicationKeysRequest {
        private APIlistApplicationKeysRequest() {
        }

        public ApplicationKeyListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyListResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.listApplicationKeysWithHttpInfo();
        }
    }

    public class APIlistAPIKeysRequest {
        private APIlistAPIKeysRequest() {
        }

        public ApiKeyListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApiKeyListResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.listAPIKeysWithHttpInfo();
        }
    }

    public class APIgetApplicationKeyRequest {
        private String key;

        private APIgetApplicationKeyRequest(String key) {
            this.key = key;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.getApplicationKeyWithHttpInfo(this.key);
        }
    }

    public class APIgetAPIKeyRequest {
        private String key;

        private APIgetAPIKeyRequest(String key) {
            this.key = key;
        }

        public ApiKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApiKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.getAPIKeyWithHttpInfo(this.key);
        }
    }

    public class APIdeleteApplicationKeyRequest {
        private String key;

        private APIdeleteApplicationKeyRequest(String key) {
            this.key = key;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.deleteApplicationKeyWithHttpInfo(this.key);
        }
    }

    public class APIdeleteAPIKeyRequest {
        private String key;

        private APIdeleteAPIKeyRequest(String key) {
            this.key = key;
        }

        public ApiKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApiKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.deleteAPIKeyWithHttpInfo(this.key);
        }
    }

    public class APIcreateApplicationKeyRequest {
        private ApplicationKey body;

        private APIcreateApplicationKeyRequest() {
        }

        public APIcreateApplicationKeyRequest body(ApplicationKey body) {
            this.body = body;
            return this;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.createApplicationKeyWithHttpInfo(this.body);
        }
    }

    public class APIcreateAPIKeyRequest {
        private ApiKey body;

        private APIcreateAPIKeyRequest() {
        }

        public APIcreateAPIKeyRequest body(ApiKey body) {
            this.body = body;
            return this;
        }

        public ApiKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApiKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.createAPIKeyWithHttpInfo(this.body);
        }
    }
}

