/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageSummaryDateOrg;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response with hourly report of all data billed by Datadog all organizations.")
@JsonPropertyOrder(value={"agent_host_top99p", "apm_host_top99p", "aws_host_top99p", "aws_lambda_func_count", "aws_lambda_invocations_sum", "billable_ingested_bytes_sum", "container_avg", "container_hwm", "custom_ts_avg", "date", "fargate_tasks_count_avg", "fargate_tasks_count_hwm", "gcp_host_top99p", "indexed_events_count_sum", "infra_host_top99p", "ingested_events_bytes_sum", "netflow_indexed_events_count_sum", "npm_host_top99p", "orgs", "rum_session_count_sum", "synthetics_browser_check_calls_count_sum", "synthetics_check_calls_count_sum", "trace_search_indexed_events_count_sum"})
public class UsageSummaryDate {
    public static final String JSON_PROPERTY_AGENT_HOST_TOP99P = "agent_host_top99p";
    private Long agentHostTop99p;
    public static final String JSON_PROPERTY_APM_HOST_TOP99P = "apm_host_top99p";
    private Long apmHostTop99p;
    public static final String JSON_PROPERTY_AWS_HOST_TOP99P = "aws_host_top99p";
    private Long awsHostTop99p;
    public static final String JSON_PROPERTY_AWS_LAMBDA_FUNC_COUNT = "aws_lambda_func_count";
    private Long awsLambdaFuncCount;
    public static final String JSON_PROPERTY_AWS_LAMBDA_INVOCATIONS_SUM = "aws_lambda_invocations_sum";
    private Long awsLambdaInvocationsSum;
    public static final String JSON_PROPERTY_BILLABLE_INGESTED_BYTES_SUM = "billable_ingested_bytes_sum";
    private Long billableIngestedBytesSum;
    public static final String JSON_PROPERTY_CONTAINER_AVG = "container_avg";
    private Long containerAvg;
    public static final String JSON_PROPERTY_CONTAINER_HWM = "container_hwm";
    private Long containerHwm;
    public static final String JSON_PROPERTY_CUSTOM_TS_AVG = "custom_ts_avg";
    private Long customTsAvg;
    public static final String JSON_PROPERTY_DATE = "date";
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_AVG = "fargate_tasks_count_avg";
    private Long fargateTasksCountAvg;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_HWM = "fargate_tasks_count_hwm";
    private Long fargateTasksCountHwm;
    public static final String JSON_PROPERTY_GCP_HOST_TOP99P = "gcp_host_top99p";
    private Long gcpHostTop99p;
    public static final String JSON_PROPERTY_INDEXED_EVENTS_COUNT_SUM = "indexed_events_count_sum";
    private Long indexedEventsCountSum;
    public static final String JSON_PROPERTY_INFRA_HOST_TOP99P = "infra_host_top99p";
    private Long infraHostTop99p;
    public static final String JSON_PROPERTY_INGESTED_EVENTS_BYTES_SUM = "ingested_events_bytes_sum";
    private Long ingestedEventsBytesSum;
    public static final String JSON_PROPERTY_NETFLOW_INDEXED_EVENTS_COUNT_SUM = "netflow_indexed_events_count_sum";
    private Long netflowIndexedEventsCountSum;
    public static final String JSON_PROPERTY_NPM_HOST_TOP99P = "npm_host_top99p";
    private Long npmHostTop99p;
    public static final String JSON_PROPERTY_ORGS = "orgs";
    private List<UsageSummaryDateOrg> orgs = null;
    public static final String JSON_PROPERTY_RUM_SESSION_COUNT_SUM = "rum_session_count_sum";
    private Long rumSessionCountSum;
    public static final String JSON_PROPERTY_SYNTHETICS_BROWSER_CHECK_CALLS_COUNT_SUM = "synthetics_browser_check_calls_count_sum";
    private Long syntheticsBrowserCheckCallsCountSum;
    public static final String JSON_PROPERTY_SYNTHETICS_CHECK_CALLS_COUNT_SUM = "synthetics_check_calls_count_sum";
    private Long syntheticsCheckCallsCountSum;
    public static final String JSON_PROPERTY_TRACE_SEARCH_INDEXED_EVENTS_COUNT_SUM = "trace_search_indexed_events_count_sum";
    private Long traceSearchIndexedEventsCountSum;

    public UsageSummaryDate agentHostTop99p(Long agentHostTop99p) {
        this.agentHostTop99p = agentHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all agent hosts over all hours in the current date for all organizations.")
    @JsonProperty(value="agent_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAgentHostTop99p() {
        return this.agentHostTop99p;
    }

    public void setAgentHostTop99p(Long agentHostTop99p) {
        this.agentHostTop99p = agentHostTop99p;
    }

    public UsageSummaryDate apmHostTop99p(Long apmHostTop99p) {
        this.apmHostTop99p = apmHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct APM hosts over all hours in the current date for all organizations.")
    @JsonProperty(value="apm_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmHostTop99p() {
        return this.apmHostTop99p;
    }

    public void setApmHostTop99p(Long apmHostTop99p) {
        this.apmHostTop99p = apmHostTop99p;
    }

    public UsageSummaryDate awsHostTop99p(Long awsHostTop99p) {
        this.awsHostTop99p = awsHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all AWS hosts over all hours in the current date for all organizations.")
    @JsonProperty(value="aws_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsHostTop99p() {
        return this.awsHostTop99p;
    }

    public void setAwsHostTop99p(Long awsHostTop99p) {
        this.awsHostTop99p = awsHostTop99p;
    }

    public UsageSummaryDate awsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of the number of functions that executed 1 or more times each hour in the current date for all organizations.")
    @JsonProperty(value="aws_lambda_func_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaFuncCount() {
        return this.awsLambdaFuncCount;
    }

    public void setAwsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
    }

    public UsageSummaryDate awsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all AWS Lambda invocations over all hours in the current date for all organizations.")
    @JsonProperty(value="aws_lambda_invocations_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaInvocationsSum() {
        return this.awsLambdaInvocationsSum;
    }

    public void setAwsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
    }

    public UsageSummaryDate billableIngestedBytesSum(Long billableIngestedBytesSum) {
        this.billableIngestedBytesSum = billableIngestedBytesSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current date for all organizations.")
    @JsonProperty(value="billable_ingested_bytes_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBillableIngestedBytesSum() {
        return this.billableIngestedBytesSum;
    }

    public void setBillableIngestedBytesSum(Long billableIngestedBytesSum) {
        this.billableIngestedBytesSum = billableIngestedBytesSum;
    }

    public UsageSummaryDate containerAvg(Long containerAvg) {
        this.containerAvg = containerAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all distinct containers over all hours in the current date for all organizations.")
    @JsonProperty(value="container_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerAvg() {
        return this.containerAvg;
    }

    public void setContainerAvg(Long containerAvg) {
        this.containerAvg = containerAvg;
    }

    public UsageSummaryDate containerHwm(Long containerHwm) {
        this.containerHwm = containerHwm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high watermark of all distinct containers over all hours in the current date for all organizations.")
    @JsonProperty(value="container_hwm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerHwm() {
        return this.containerHwm;
    }

    public void setContainerHwm(Long containerHwm) {
        this.containerHwm = containerHwm;
    }

    public UsageSummaryDate customTsAvg(Long customTsAvg) {
        this.customTsAvg = customTsAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average number of distinct custom metrics over all hours in the current date for all organizations.")
    @JsonProperty(value="custom_ts_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCustomTsAvg() {
        return this.customTsAvg;
    }

    public void setCustomTsAvg(Long customTsAvg) {
        this.customTsAvg = customTsAvg;
    }

    public UsageSummaryDate date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date for the usage.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public UsageSummaryDate fargateTasksCountAvg(Long fargateTasksCountAvg) {
        this.fargateTasksCountAvg = fargateTasksCountAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high watermark of all Fargate tasks over all hours in the current date for all organizations.")
    @JsonProperty(value="fargate_tasks_count_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountAvg() {
        return this.fargateTasksCountAvg;
    }

    public void setFargateTasksCountAvg(Long fargateTasksCountAvg) {
        this.fargateTasksCountAvg = fargateTasksCountAvg;
    }

    public UsageSummaryDate fargateTasksCountHwm(Long fargateTasksCountHwm) {
        this.fargateTasksCountHwm = fargateTasksCountHwm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all Fargate tasks over all hours in the current date for all organizations.")
    @JsonProperty(value="fargate_tasks_count_hwm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountHwm() {
        return this.fargateTasksCountHwm;
    }

    public void setFargateTasksCountHwm(Long fargateTasksCountHwm) {
        this.fargateTasksCountHwm = fargateTasksCountHwm;
    }

    public UsageSummaryDate gcpHostTop99p(Long gcpHostTop99p) {
        this.gcpHostTop99p = gcpHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all GCP hosts over all hours in the current date for all organizations.")
    @JsonProperty(value="gcp_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getGcpHostTop99p() {
        return this.gcpHostTop99p;
    }

    public void setGcpHostTop99p(Long gcpHostTop99p) {
        this.gcpHostTop99p = gcpHostTop99p;
    }

    public UsageSummaryDate indexedEventsCountSum(Long indexedEventsCountSum) {
        this.indexedEventsCountSum = indexedEventsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log events indexed over all hours in the current date for all organizations.")
    @JsonProperty(value="indexed_events_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventsCountSum() {
        return this.indexedEventsCountSum;
    }

    public void setIndexedEventsCountSum(Long indexedEventsCountSum) {
        this.indexedEventsCountSum = indexedEventsCountSum;
    }

    public UsageSummaryDate infraHostTop99p(Long infraHostTop99p) {
        this.infraHostTop99p = infraHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct infrastructure hosts over all hours in the current date for all organizations.")
    @JsonProperty(value="infra_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInfraHostTop99p() {
        return this.infraHostTop99p;
    }

    public void setInfraHostTop99p(Long infraHostTop99p) {
        this.infraHostTop99p = infraHostTop99p;
    }

    public UsageSummaryDate ingestedEventsBytesSum(Long ingestedEventsBytesSum) {
        this.ingestedEventsBytesSum = ingestedEventsBytesSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current date for all organizations.")
    @JsonProperty(value="ingested_events_bytes_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIngestedEventsBytesSum() {
        return this.ingestedEventsBytesSum;
    }

    public void setIngestedEventsBytesSum(Long ingestedEventsBytesSum) {
        this.ingestedEventsBytesSum = ingestedEventsBytesSum;
    }

    public UsageSummaryDate netflowIndexedEventsCountSum(Long netflowIndexedEventsCountSum) {
        this.netflowIndexedEventsCountSum = netflowIndexedEventsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Network flows indexed over all hours in the current date for all organizations.")
    @JsonProperty(value="netflow_indexed_events_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNetflowIndexedEventsCountSum() {
        return this.netflowIndexedEventsCountSum;
    }

    public void setNetflowIndexedEventsCountSum(Long netflowIndexedEventsCountSum) {
        this.netflowIndexedEventsCountSum = netflowIndexedEventsCountSum;
    }

    public UsageSummaryDate npmHostTop99p(Long npmHostTop99p) {
        this.npmHostTop99p = npmHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct Networks hosts over all hours in the current date for all organizations.")
    @JsonProperty(value="npm_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNpmHostTop99p() {
        return this.npmHostTop99p;
    }

    public void setNpmHostTop99p(Long npmHostTop99p) {
        this.npmHostTop99p = npmHostTop99p;
    }

    public UsageSummaryDate orgs(List<UsageSummaryDateOrg> orgs) {
        this.orgs = orgs;
        return this;
    }

    public UsageSummaryDate addOrgsItem(UsageSummaryDateOrg orgsItem) {
        if (this.orgs == null) {
            this.orgs = new ArrayList<UsageSummaryDateOrg>();
        }
        this.orgs.add(orgsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Organizations associated with a user.")
    @JsonProperty(value="orgs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageSummaryDateOrg> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<UsageSummaryDateOrg> orgs) {
        this.orgs = orgs;
    }

    public UsageSummaryDate rumSessionCountSum(Long rumSessionCountSum) {
        this.rumSessionCountSum = rumSessionCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all RUM Sessions over all hours in the current date for all organizations")
    @JsonProperty(value="rum_session_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRumSessionCountSum() {
        return this.rumSessionCountSum;
    }

    public void setRumSessionCountSum(Long rumSessionCountSum) {
        this.rumSessionCountSum = rumSessionCountSum;
    }

    public UsageSummaryDate syntheticsBrowserCheckCallsCountSum(Long syntheticsBrowserCheckCallsCountSum) {
        this.syntheticsBrowserCheckCallsCountSum = syntheticsBrowserCheckCallsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic browser tests over all hours in the current date for all organizations.")
    @JsonProperty(value="synthetics_browser_check_calls_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsBrowserCheckCallsCountSum() {
        return this.syntheticsBrowserCheckCallsCountSum;
    }

    public void setSyntheticsBrowserCheckCallsCountSum(Long syntheticsBrowserCheckCallsCountSum) {
        this.syntheticsBrowserCheckCallsCountSum = syntheticsBrowserCheckCallsCountSum;
    }

    public UsageSummaryDate syntheticsCheckCallsCountSum(Long syntheticsCheckCallsCountSum) {
        this.syntheticsCheckCallsCountSum = syntheticsCheckCallsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic API tests over all hours in the current date for all organizations.")
    @JsonProperty(value="synthetics_check_calls_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsCheckCallsCountSum() {
        return this.syntheticsCheckCallsCountSum;
    }

    public void setSyntheticsCheckCallsCountSum(Long syntheticsCheckCallsCountSum) {
        this.syntheticsCheckCallsCountSum = syntheticsCheckCallsCountSum;
    }

    public UsageSummaryDate traceSearchIndexedEventsCountSum(Long traceSearchIndexedEventsCountSum) {
        this.traceSearchIndexedEventsCountSum = traceSearchIndexedEventsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all analyzed spans indexed over all hours in the current date for all organizations.")
    @JsonProperty(value="trace_search_indexed_events_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTraceSearchIndexedEventsCountSum() {
        return this.traceSearchIndexedEventsCountSum;
    }

    public void setTraceSearchIndexedEventsCountSum(Long traceSearchIndexedEventsCountSum) {
        this.traceSearchIndexedEventsCountSum = traceSearchIndexedEventsCountSum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageSummaryDate usageSummaryDate = (UsageSummaryDate)o;
        return Objects.equals(this.agentHostTop99p, usageSummaryDate.agentHostTop99p) && Objects.equals(this.apmHostTop99p, usageSummaryDate.apmHostTop99p) && Objects.equals(this.awsHostTop99p, usageSummaryDate.awsHostTop99p) && Objects.equals(this.awsLambdaFuncCount, usageSummaryDate.awsLambdaFuncCount) && Objects.equals(this.awsLambdaInvocationsSum, usageSummaryDate.awsLambdaInvocationsSum) && Objects.equals(this.billableIngestedBytesSum, usageSummaryDate.billableIngestedBytesSum) && Objects.equals(this.containerAvg, usageSummaryDate.containerAvg) && Objects.equals(this.containerHwm, usageSummaryDate.containerHwm) && Objects.equals(this.customTsAvg, usageSummaryDate.customTsAvg) && Objects.equals(this.date, usageSummaryDate.date) && Objects.equals(this.fargateTasksCountAvg, usageSummaryDate.fargateTasksCountAvg) && Objects.equals(this.fargateTasksCountHwm, usageSummaryDate.fargateTasksCountHwm) && Objects.equals(this.gcpHostTop99p, usageSummaryDate.gcpHostTop99p) && Objects.equals(this.indexedEventsCountSum, usageSummaryDate.indexedEventsCountSum) && Objects.equals(this.infraHostTop99p, usageSummaryDate.infraHostTop99p) && Objects.equals(this.ingestedEventsBytesSum, usageSummaryDate.ingestedEventsBytesSum) && Objects.equals(this.netflowIndexedEventsCountSum, usageSummaryDate.netflowIndexedEventsCountSum) && Objects.equals(this.npmHostTop99p, usageSummaryDate.npmHostTop99p) && Objects.equals(this.orgs, usageSummaryDate.orgs) && Objects.equals(this.rumSessionCountSum, usageSummaryDate.rumSessionCountSum) && Objects.equals(this.syntheticsBrowserCheckCallsCountSum, usageSummaryDate.syntheticsBrowserCheckCallsCountSum) && Objects.equals(this.syntheticsCheckCallsCountSum, usageSummaryDate.syntheticsCheckCallsCountSum) && Objects.equals(this.traceSearchIndexedEventsCountSum, usageSummaryDate.traceSearchIndexedEventsCountSum);
    }

    public int hashCode() {
        return Objects.hash(this.agentHostTop99p, this.apmHostTop99p, this.awsHostTop99p, this.awsLambdaFuncCount, this.awsLambdaInvocationsSum, this.billableIngestedBytesSum, this.containerAvg, this.containerHwm, this.customTsAvg, this.date, this.fargateTasksCountAvg, this.fargateTasksCountHwm, this.gcpHostTop99p, this.indexedEventsCountSum, this.infraHostTop99p, this.ingestedEventsBytesSum, this.netflowIndexedEventsCountSum, this.npmHostTop99p, this.orgs, this.rumSessionCountSum, this.syntheticsBrowserCheckCallsCountSum, this.syntheticsCheckCallsCountSum, this.traceSearchIndexedEventsCountSum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageSummaryDate {\n");
        sb.append("    agentHostTop99p: ").append(this.toIndentedString(this.agentHostTop99p)).append("\n");
        sb.append("    apmHostTop99p: ").append(this.toIndentedString(this.apmHostTop99p)).append("\n");
        sb.append("    awsHostTop99p: ").append(this.toIndentedString(this.awsHostTop99p)).append("\n");
        sb.append("    awsLambdaFuncCount: ").append(this.toIndentedString(this.awsLambdaFuncCount)).append("\n");
        sb.append("    awsLambdaInvocationsSum: ").append(this.toIndentedString(this.awsLambdaInvocationsSum)).append("\n");
        sb.append("    billableIngestedBytesSum: ").append(this.toIndentedString(this.billableIngestedBytesSum)).append("\n");
        sb.append("    containerAvg: ").append(this.toIndentedString(this.containerAvg)).append("\n");
        sb.append("    containerHwm: ").append(this.toIndentedString(this.containerHwm)).append("\n");
        sb.append("    customTsAvg: ").append(this.toIndentedString(this.customTsAvg)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    fargateTasksCountAvg: ").append(this.toIndentedString(this.fargateTasksCountAvg)).append("\n");
        sb.append("    fargateTasksCountHwm: ").append(this.toIndentedString(this.fargateTasksCountHwm)).append("\n");
        sb.append("    gcpHostTop99p: ").append(this.toIndentedString(this.gcpHostTop99p)).append("\n");
        sb.append("    indexedEventsCountSum: ").append(this.toIndentedString(this.indexedEventsCountSum)).append("\n");
        sb.append("    infraHostTop99p: ").append(this.toIndentedString(this.infraHostTop99p)).append("\n");
        sb.append("    ingestedEventsBytesSum: ").append(this.toIndentedString(this.ingestedEventsBytesSum)).append("\n");
        sb.append("    netflowIndexedEventsCountSum: ").append(this.toIndentedString(this.netflowIndexedEventsCountSum)).append("\n");
        sb.append("    npmHostTop99p: ").append(this.toIndentedString(this.npmHostTop99p)).append("\n");
        sb.append("    orgs: ").append(this.toIndentedString(this.orgs)).append("\n");
        sb.append("    rumSessionCountSum: ").append(this.toIndentedString(this.rumSessionCountSum)).append("\n");
        sb.append("    syntheticsBrowserCheckCallsCountSum: ").append(this.toIndentedString(this.syntheticsBrowserCheckCallsCountSum)).append("\n");
        sb.append("    syntheticsCheckCallsCountSum: ").append(this.toIndentedString(this.syntheticsCheckCallsCountSum)).append("\n");
        sb.append("    traceSearchIndexedEventsCountSum: ").append(this.toIndentedString(this.traceSearchIndexedEventsCountSum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

