/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.LogsPipeline;
import com.datadog.api.v1.client.model.LogsPipelinesOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class LogsPipelinesApi {
    private ApiClient apiClient;

    public LogsPipelinesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsPipelinesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<LogsPipeline> createLogsPipelineWithHttpInfo(LogsPipeline body) throws ApiException {
        LogsPipeline localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createLogsPipeline");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsPipeline> localVarReturnType = new GenericType<LogsPipeline>(){};
        return this.apiClient.invokeAPI("LogsPipelinesApi.createLogsPipeline", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateLogsPipelineRequest createLogsPipeline() throws ApiException {
        return new APIcreateLogsPipelineRequest();
    }

    private ApiResponse<Void> deleteLogsPipelineWithHttpInfo(String pipelineId) throws ApiException {
        Object localVarPostBody = null;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling deleteLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteLogsPipeline");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsPipelinesApi.deleteLogsPipeline", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public APIdeleteLogsPipelineRequest deleteLogsPipeline(String pipelineId) throws ApiException {
        return new APIdeleteLogsPipelineRequest(pipelineId);
    }

    private ApiResponse<LogsPipeline> getLogsPipelineWithHttpInfo(String pipelineId) throws ApiException {
        Object localVarPostBody = null;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsPipeline");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsPipeline> localVarReturnType = new GenericType<LogsPipeline>(){};
        return this.apiClient.invokeAPI("LogsPipelinesApi.getLogsPipeline", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetLogsPipelineRequest getLogsPipeline(String pipelineId) throws ApiException {
        return new APIgetLogsPipelineRequest(pipelineId);
    }

    private ApiResponse<LogsPipelinesOrder> getLogsPipelineOrderWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/pipeline-order";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsPipelineOrder");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsPipelinesOrder> localVarReturnType = new GenericType<LogsPipelinesOrder>(){};
        return this.apiClient.invokeAPI("LogsPipelinesApi.getLogsPipelineOrder", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetLogsPipelineOrderRequest getLogsPipelineOrder() throws ApiException {
        return new APIgetLogsPipelineOrderRequest();
    }

    private ApiResponse<List<LogsPipeline>> listLogsPipelinesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/pipelines";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsPipelines");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<LogsPipeline>> localVarReturnType = new GenericType<List<LogsPipeline>>(){};
        return this.apiClient.invokeAPI("LogsPipelinesApi.listLogsPipelines", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistLogsPipelinesRequest listLogsPipelines() throws ApiException {
        return new APIlistLogsPipelinesRequest();
    }

    private ApiResponse<LogsPipeline> updateLogsPipelineWithHttpInfo(String pipelineId, LogsPipeline body) throws ApiException {
        LogsPipeline localVarPostBody = body;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling updateLogsPipeline");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsPipeline");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsPipeline> localVarReturnType = new GenericType<LogsPipeline>(){};
        return this.apiClient.invokeAPI("LogsPipelinesApi.updateLogsPipeline", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateLogsPipelineRequest updateLogsPipeline(String pipelineId) throws ApiException {
        return new APIupdateLogsPipelineRequest(pipelineId);
    }

    private ApiResponse<LogsPipelinesOrder> updateLogsPipelineOrderWithHttpInfo(LogsPipelinesOrder body) throws ApiException {
        LogsPipelinesOrder localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsPipelineOrder");
        }
        String localVarPath = "/api/v1/logs/config/pipeline-order";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsPipelineOrder");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsPipelinesOrder> localVarReturnType = new GenericType<LogsPipelinesOrder>(){};
        return this.apiClient.invokeAPI("LogsPipelinesApi.updateLogsPipelineOrder", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateLogsPipelineOrderRequest updateLogsPipelineOrder() throws ApiException {
        return new APIupdateLogsPipelineOrderRequest();
    }

    public class APIupdateLogsPipelineOrderRequest {
        private LogsPipelinesOrder body;

        private APIupdateLogsPipelineOrderRequest() {
        }

        public APIupdateLogsPipelineOrderRequest body(LogsPipelinesOrder body) {
            this.body = body;
            return this;
        }

        public LogsPipelinesOrder execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsPipelinesOrder> executeWithHttpInfo() throws ApiException {
            return LogsPipelinesApi.this.updateLogsPipelineOrderWithHttpInfo(this.body);
        }
    }

    public class APIupdateLogsPipelineRequest {
        private String pipelineId;
        private LogsPipeline body;

        private APIupdateLogsPipelineRequest(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public APIupdateLogsPipelineRequest body(LogsPipeline body) {
            this.body = body;
            return this;
        }

        public LogsPipeline execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsPipeline> executeWithHttpInfo() throws ApiException {
            return LogsPipelinesApi.this.updateLogsPipelineWithHttpInfo(this.pipelineId, this.body);
        }
    }

    public class APIlistLogsPipelinesRequest {
        private APIlistLogsPipelinesRequest() {
        }

        public List<LogsPipeline> execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<List<LogsPipeline>> executeWithHttpInfo() throws ApiException {
            return LogsPipelinesApi.this.listLogsPipelinesWithHttpInfo();
        }
    }

    public class APIgetLogsPipelineOrderRequest {
        private APIgetLogsPipelineOrderRequest() {
        }

        public LogsPipelinesOrder execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsPipelinesOrder> executeWithHttpInfo() throws ApiException {
            return LogsPipelinesApi.this.getLogsPipelineOrderWithHttpInfo();
        }
    }

    public class APIgetLogsPipelineRequest {
        private String pipelineId;

        private APIgetLogsPipelineRequest(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public LogsPipeline execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsPipeline> executeWithHttpInfo() throws ApiException {
            return LogsPipelinesApi.this.getLogsPipelineWithHttpInfo(this.pipelineId);
        }
    }

    public class APIdeleteLogsPipelineRequest {
        private String pipelineId;

        private APIdeleteLogsPipelineRequest(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return LogsPipelinesApi.this.deleteLogsPipelineWithHttpInfo(this.pipelineId);
        }
    }

    public class APIcreateLogsPipelineRequest {
        private LogsPipeline body;

        private APIcreateLogsPipelineRequest() {
        }

        public APIcreateLogsPipelineRequest body(LogsPipeline body) {
            this.body = body;
            return this;
        }

        public LogsPipeline execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsPipeline> executeWithHttpInfo() throws ApiException {
            return LogsPipelinesApi.this.createLogsPipelineWithHttpInfo(this.body);
        }
    }
}

