/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.HostListResponse;
import com.datadog.api.v1.client.model.HostMuteResponse;
import com.datadog.api.v1.client.model.HostMuteSettings;
import com.datadog.api.v1.client.model.HostTotals;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class HostsApi {
    private ApiClient apiClient;

    public HostsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HostsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<HostTotals> getHostTotalsWithHttpInfo(Long from) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/hosts/totals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarHeaderParams.put("DD-OPERATION-ID", "getHostTotals");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostTotals> localVarReturnType = new GenericType<HostTotals>(){};
        return this.apiClient.invokeAPI("HostsApi.getHostTotals", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetHostTotalsRequest getHostTotals() throws ApiException {
        return new APIgetHostTotalsRequest();
    }

    private ApiResponse<HostListResponse> listHostsWithHttpInfo(String filter, String sortField, String sortDir, Long start, Long count, Long from) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarHeaderParams.put("DD-OPERATION-ID", "listHosts");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostListResponse> localVarReturnType = new GenericType<HostListResponse>(){};
        return this.apiClient.invokeAPI("HostsApi.listHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistHostsRequest listHosts() throws ApiException {
        return new APIlistHostsRequest();
    }

    private ApiResponse<HostMuteResponse> muteHostWithHttpInfo(String hostName, HostMuteSettings body) throws ApiException {
        HostMuteSettings localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling muteHost");
        }
        String localVarPath = "/api/v1/host/{host_name}/mute".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "muteHost");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostMuteResponse> localVarReturnType = new GenericType<HostMuteResponse>(){};
        return this.apiClient.invokeAPI("HostsApi.muteHost", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APImuteHostRequest muteHost(String hostName) throws ApiException {
        return new APImuteHostRequest(hostName);
    }

    private ApiResponse<HostMuteResponse> unmuteHostWithHttpInfo(String hostName) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling unmuteHost");
        }
        String localVarPath = "/api/v1/host/{host_name}/unmute".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "unmuteHost");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostMuteResponse> localVarReturnType = new GenericType<HostMuteResponse>(){};
        return this.apiClient.invokeAPI("HostsApi.unmuteHost", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIunmuteHostRequest unmuteHost(String hostName) throws ApiException {
        return new APIunmuteHostRequest(hostName);
    }

    public class APIunmuteHostRequest {
        private String hostName;

        private APIunmuteHostRequest(String hostName) {
            this.hostName = hostName;
        }

        public HostMuteResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<HostMuteResponse> executeWithHttpInfo() throws ApiException {
            return HostsApi.this.unmuteHostWithHttpInfo(this.hostName);
        }
    }

    public class APImuteHostRequest {
        private String hostName;
        private HostMuteSettings body;

        private APImuteHostRequest(String hostName) {
            this.hostName = hostName;
        }

        public APImuteHostRequest body(HostMuteSettings body) {
            this.body = body;
            return this;
        }

        public HostMuteResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<HostMuteResponse> executeWithHttpInfo() throws ApiException {
            return HostsApi.this.muteHostWithHttpInfo(this.hostName, this.body);
        }
    }

    public class APIlistHostsRequest {
        private String filter;
        private String sortField;
        private String sortDir;
        private Long start;
        private Long count;
        private Long from;

        private APIlistHostsRequest() {
        }

        public APIlistHostsRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public APIlistHostsRequest sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public APIlistHostsRequest sortDir(String sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public APIlistHostsRequest start(Long start) {
            this.start = start;
            return this;
        }

        public APIlistHostsRequest count(Long count) {
            this.count = count;
            return this;
        }

        public APIlistHostsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public HostListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<HostListResponse> executeWithHttpInfo() throws ApiException {
            return HostsApi.this.listHostsWithHttpInfo(this.filter, this.sortField, this.sortDir, this.start, this.count, this.from);
        }
    }

    public class APIgetHostTotalsRequest {
        private Long from;

        private APIgetHostTotalsRequest() {
        }

        public APIgetHostTotalsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public HostTotals execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<HostTotals> executeWithHttpInfo() throws ApiException {
            return HostsApi.this.getHostTotalsWithHttpInfo(this.from);
        }
    }
}

