/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.coverage;

import com.databricks.internal.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.databricks.internal.jts.algorithm.locate.PointOnGeometryLocator;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.Polygon;

class CoveragePolygon {
    private Polygon polygon;
    private Envelope polyEnv;
    IndexedPointInAreaLocator locator;

    public CoveragePolygon(Polygon poly) {
        this.polygon = poly;
        this.polyEnv = this.polygon.getEnvelopeInternal();
    }

    public boolean intersectsEnv(Envelope env) {
        return !(env.getMinX() > this.polyEnv.getMaxX() || env.getMaxX() < this.polyEnv.getMinX() || env.getMinY() > this.polyEnv.getMaxY() || env.getMaxY() < this.polyEnv.getMinY());
    }

    private boolean intersectsEnv(Coordinate p) {
        return !(p.x > this.polyEnv.getMaxX() || p.x < this.polyEnv.getMinX() || p.y > this.polyEnv.getMaxY() || p.y < this.polyEnv.getMinY());
    }

    public boolean contains(Coordinate p) {
        if (!this.intersectsEnv(p)) {
            return false;
        }
        PointOnGeometryLocator pia = this.getLocator();
        return 0 == pia.locate(p);
    }

    private PointOnGeometryLocator getLocator() {
        if (this.locator == null) {
            this.locator = new IndexedPointInAreaLocator(this.polygon);
        }
        return this.locator;
    }
}

