/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.parser;

import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.parser.DefaultLimitChecker;
import com.databricks.client.sqlengine.parser.IPTLimitChecker;
import com.databricks.client.sqlengine.parser.PTNodeFactory;
import com.databricks.client.sqlengine.parser.PTParseErrorInfo;
import com.databricks.client.sqlengine.parser.generated.YYParser;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.type.PTNonterminalType;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.sqlengine.parser.type.PTStringConstraint;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;

public class PTParser {
    private PTParser() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static IPTNode parse(String string) throws SQLEngineException, ErrorException {
        return PTParser.parse(string, new DefaultLimitChecker());
    }

    public static IPTNode parse(String string, IPTLimitChecker iPTLimitChecker) throws SQLEngineException, ErrorException {
        if (null == string) {
            throw new NullPointerException("sqlStatement must not be null");
        }
        if (null == iPTLimitChecker) {
            throw new NullPointerException("limitChecker must not be null");
        }
        iPTLimitChecker.checkString(PTStringConstraint.STATEMENT_LEN, string);
        return YYParser.doParse(string, iPTLimitChecker);
    }

    public static IPTNode processTopLevelStatement(IPTNode iPTNode, PTNodeFactory pTNodeFactory) throws SQLEngineException {
        IPTNode iPTNode2 = !(iPTNode instanceof PTNonterminalNode) || ((PTNonterminalNode)iPTNode).getNonterminalType() != PTNonterminalType.QUERY_SPEC_WITH_WITH_CLAUSE ? iPTNode : ((PTNonterminalNode)iPTNode).getChild(PTPositionalType.QUERY_EXPRESSION);
        if (!(iPTNode2 instanceof PTNonterminalNode) || ((PTNonterminalNode)iPTNode2).getNonterminalType() != PTNonterminalType.SORTED_SELECT_STATEMENT) {
            return iPTNode;
        }
        PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode2;
        PTNonterminalNode pTNonterminalNode2 = pTNodeFactory.buildNonterminalNode(PTNonterminalType.TOP_LEVEL_SELECT_STATEMENT, new Object[]{PTPositionalType.SELECT, pTNonterminalNode.getChild(PTPositionalType.SELECT), PTPositionalType.ORDER_BY, pTNonterminalNode.getChild(PTPositionalType.ORDER_BY)});
        if (pTNonterminalNode != iPTNode) {
            ((PTNonterminalNode)iPTNode).replaceChild(PTPositionalType.QUERY_EXPRESSION, pTNonterminalNode2);
            return iPTNode;
        }
        return pTNonterminalNode2;
    }

    public static IPTNode processCursorSpecificationWithOrderBy(IPTNode iPTNode, IPTNode iPTNode2, IPTNode iPTNode3, PTNodeFactory pTNodeFactory, ITokenInfo iTokenInfo, String string) throws SQLEngineException {
        IPTNode iPTNode4;
        if (!iPTNode3.isEmptyNode()) {
            IPTNode iPTNode5 = iPTNode4 = !(iPTNode instanceof PTNonterminalNode) || ((PTNonterminalNode)iPTNode).getNonterminalType() != PTNonterminalType.QUERY_SPEC_WITH_WITH_CLAUSE ? iPTNode : ((PTNonterminalNode)iPTNode).getChild(PTPositionalType.QUERY_EXPRESSION);
            if (!(iPTNode4 instanceof PTNonterminalNode) || ((PTNonterminalNode)iPTNode4).getNonterminalType() != PTNonterminalType.SELECT_STATEMENT) {
                throw PTParseErrorInfo.makeSyntaxError(string, iTokenInfo.getFirstColumn() - 6);
            }
            PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode4;
            if (!pTNonterminalNode.getChild(PTPositionalType.SELECT_LIMIT).isEmptyNode()) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TOP_AND_LIMIT.name());
            }
            PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)iPTNode3;
            PTNonterminalNode pTNonterminalNode3 = PTNonterminalType.LIMIT == pTNonterminalNode2.getNonterminalType() ? pTNodeFactory.buildNonterminalNode(PTNonterminalType.SELECT_LIMIT, new Object[]{PTPositionalType.TOP_VALUE_SPEC, pTNonterminalNode2.getChild(PTPositionalType.TOP_VALUE_SPEC)}) : pTNodeFactory.buildNonterminalNode(PTNonterminalType.SELECT_LIMIT_SKIP, new Object[]{PTPositionalType.SKIP_VALUE_SPEC, pTNonterminalNode2.getChild(PTPositionalType.SKIP_VALUE_SPEC), PTPositionalType.TOP_VALUE_SPEC, pTNonterminalNode2.getChild(PTPositionalType.TOP_VALUE_SPEC)});
            pTNonterminalNode.replaceChild(PTPositionalType.SELECT_LIMIT, pTNonterminalNode3);
        }
        if (iPTNode2.isEmptyNode()) {
            return iPTNode;
        }
        if (iPTNode instanceof PTNonterminalNode && ((PTNonterminalNode)iPTNode).getNonterminalType() == PTNonterminalType.QUERY_SPEC_WITH_WITH_CLAUSE) {
            iPTNode4 = (PTNonterminalNode)iPTNode;
            ((PTNonterminalNode)iPTNode4).replaceChild(PTPositionalType.QUERY_EXPRESSION, pTNodeFactory.buildNonterminalNode(PTNonterminalType.SORTED_SELECT_STATEMENT, new Object[]{PTPositionalType.SELECT, ((PTNonterminalNode)iPTNode4).getChild(PTPositionalType.QUERY_EXPRESSION), PTPositionalType.ORDER_BY, iPTNode2}));
            return iPTNode4;
        }
        return pTNodeFactory.buildNonterminalNode(PTNonterminalType.SORTED_SELECT_STATEMENT, new Object[]{PTPositionalType.SELECT, iPTNode, PTPositionalType.ORDER_BY, iPTNode2});
    }

    public static void transformLimitToTop(IPTNode iPTNode, IPTNode iPTNode2, PTNodeFactory pTNodeFactory, ITokenInfo iTokenInfo, String string) throws SQLEngineException {
        if (iPTNode2.isEmptyNode()) {
            return;
        }
        PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
        PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)iPTNode2;
        if (pTNonterminalNode.getNonterminalType() != PTNonterminalType.SELECT_STATEMENT) {
            throw PTParseErrorInfo.makeSyntaxError(string, iTokenInfo.getFirstColumn() - 6);
        }
        if (!pTNonterminalNode.getChild(PTPositionalType.SELECT_LIMIT).isEmptyNode()) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TOP_AND_LIMIT.name());
        }
        PTNonterminalNode pTNonterminalNode3 = null;
        pTNonterminalNode3 = PTNonterminalType.LIMIT == pTNonterminalNode2.getNonterminalType() ? pTNodeFactory.buildNonterminalNode(PTNonterminalType.SELECT_LIMIT, new Object[]{PTPositionalType.TOP_VALUE_SPEC, pTNonterminalNode2.getChild(PTPositionalType.TOP_VALUE_SPEC)}) : pTNodeFactory.buildNonterminalNode(PTNonterminalType.SELECT_LIMIT_SKIP, new Object[]{PTPositionalType.SKIP_VALUE_SPEC, pTNonterminalNode2.getChild(PTPositionalType.SKIP_VALUE_SPEC), PTPositionalType.TOP_VALUE_SPEC, pTNonterminalNode2.getChild(PTPositionalType.TOP_VALUE_SPEC)});
        pTNonterminalNode.replaceChild(PTPositionalType.SELECT_LIMIT, pTNonterminalNode3);
    }

    public static interface ITokenInfo {
        public String getToken();

        public int getFirstColumn();

        public int getLastColumn();
    }
}

