/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;

public abstract class ETAbstractPowerFn
extends ETScalarFn {
    public ETAbstractPowerFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        if (list.size() != 2) {
            throw new IllegalArgumentException("args must be of size 2!");
        }
        if (list2.size() != 2) {
            throw new IllegalArgumentException("argMeta must be of size 2!");
        }
        if (list2.get(0).getTypeMetadata().getType() != 8) {
            throw new IllegalArgumentException("first argument must be of type SQL_DOUBLE!");
        }
        if (list2.get(1).getTypeMetadata().getType() != this.getExponentSqlType()) {
            throw new IllegalArgumentException("result metadata must be of type " + TypeUtilities.sqlTypeToString(this.getExponentSqlType()) + "!");
        }
        if (iColumn.getTypeMetadata().getType() != 8) {
            throw new IllegalArgumentException("result metadata must be of type SQL_DOUBLE!");
        }
    }

    @Override
    public String getLogString() {
        return "ETPowerFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        eTDataRequest.getData().setDouble(Math.pow(iSqlDataWrapper.getDouble(), this.getExponentFromArg(iSqlDataWrapper2)));
        return false;
    }

    protected abstract short getExponentSqlType();

    protected abstract double getExponentFromArg(ISqlDataWrapper var1);
}

