/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aeoptimizer;

import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AEPassdownFilter;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AERelationalExprHandler;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.IAEOptimizer;
import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETable;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.databricks.client.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.databricks.client.support.Pair;
import com.databricks.client.support.exceptions.ErrorException;

public final class AEPassdownOpOptimizer
implements IAEOptimizer {
    private final DSIExtOperationHandlerFactory m_opHandlerFactory;

    public AEPassdownOpOptimizer(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
    }

    @Override
    public void optimize(IAEStatement iAEStatement) throws ErrorException {
        iAEStatement.acceptVisitor(new AEDefaultVisitor<Void>(){

            @Override
            public Void visit(AEQuery aEQuery) throws ErrorException {
                aEQuery.setOperand(new AERelationalExprHandler(AEPassdownOpOptimizer.this.m_opHandlerFactory).passdown(aEQuery.getOperand()));
                return null;
            }

            @Override
            public Void visit(AEUpdate aEUpdate) throws ErrorException {
                new AERelationalExprHandler(AEPassdownOpOptimizer.this.m_opHandlerFactory).passdownSubQueries(aEUpdate.getSetClauses());
                AEBooleanExpr aEBooleanExpr = aEUpdate.getUpdateCondition();
                AETable aETable = aEUpdate.getTable();
                Pair pair = AEPassdownOpOptimizer.this.doPassdown(aETable, aEBooleanExpr);
                aEUpdate.setTable((AETable)pair.key());
                aEUpdate.setUpdateCondition((AEBooleanExpr)pair.value());
                return null;
            }

            @Override
            public Void visit(AEDelete aEDelete) throws ErrorException {
                AEBooleanExpr aEBooleanExpr = aEDelete.getCondition();
                AETable aETable = aEDelete.getTable();
                Pair pair = AEPassdownOpOptimizer.this.doPassdown(aETable, aEBooleanExpr);
                aEDelete.setTable((AETable)pair.key());
                aEDelete.setCondition((AEBooleanExpr)pair.value());
                return null;
            }

            @Override
            public Void visit(AEInsert aEInsert) throws ErrorException {
                aEInsert.setRelationalExpr(new AERelationalExprHandler(AEPassdownOpOptimizer.this.m_opHandlerFactory).passdown(aEInsert.getRelationalExpr()));
                return null;
            }

            @Override
            public Void visit(AEProcedureCall aEProcedureCall) throws ErrorException {
                new AERelationalExprHandler(AEPassdownOpOptimizer.this.m_opHandlerFactory).passdownSubQueries(aEProcedureCall.getOperand().getArguments());
                return null;
            }

            @Override
            protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                return null;
            }
        });
    }

    private Pair<AETable, AEBooleanExpr> doPassdown(AETable aETable, AEBooleanExpr aEBooleanExpr) {
        IBooleanExprHandler iBooleanExprHandler;
        assert (aETable != null);
        assert (aEBooleanExpr != null);
        if (aEBooleanExpr instanceof AEBooleanTrue) {
            return new Pair<AETable, AEBooleanExpr>(aETable, aEBooleanExpr);
        }
        new AERelationalExprHandler(this.m_opHandlerFactory).passdownSubQueries(aEBooleanExpr);
        IBooleanExprHandler iBooleanExprHandler2 = iBooleanExprHandler = this.m_opHandlerFactory == null ? null : this.m_opHandlerFactory.createFilterHandler(aETable.getTable());
        if (iBooleanExprHandler == null) {
            return new Pair<AETable, AEBooleanExpr>(aETable, aEBooleanExpr);
        }
        Pair<DSIExtJResultSet, AEBooleanExpr> pair = new AEPassdownFilter(iBooleanExprHandler).passdown(aEBooleanExpr);
        if (pair.key() != null) {
            aETable.setTable(pair.key());
        }
        if (pair.value() == null) {
            pair.setValue(new AEBooleanTrue());
        }
        return new Pair<AETable, AEBooleanExpr>(aETable, pair.value());
    }
}

