/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.jdbc;

import com.databricks.client.dsi.core.interfaces.IConnection;
import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.hivecommon.core.HiveJDBCStatement;
import com.databricks.client.hivecommon.jdbc42.Hive42Connection;
import com.databricks.client.hivecommon.jdbc42.Hive42DatabaseMetaData;
import com.databricks.client.hivecommon.jdbc42.Hive42PreparedStatement;
import com.databricks.client.hivecommon.jdbc42.Hive42Statement;
import com.databricks.client.jdbc.common.SCallableStatement;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.SDatabaseMetaData;
import com.databricks.client.jdbc.common.SPreparedStatement;
import com.databricks.client.jdbc.common.SStatement;
import com.databricks.client.jdbc.jdbc42.JDBC42ObjectFactory;
import com.databricks.client.support.ILogger;
import java.sql.SQLException;

public class SparkJDBCObjectFactory
extends JDBC42ObjectFactory {
    @Override
    protected SCallableStatement createCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return super.createCallableStatement(string, iStatement, sConnection, n);
    }

    @Override
    protected SConnection createConnection(IConnection iConnection, String string) throws SQLException {
        return new Hive42Connection(iConnection, string);
    }

    @Override
    protected SDatabaseMetaData createDatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        if (sConnection instanceof Hive42Connection) {
            return new Hive42DatabaseMetaData(sConnection, iLogger);
        }
        return super.createDatabaseMetaData(sConnection, iLogger);
    }

    @Override
    protected SPreparedStatement createPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        if (iStatement instanceof HiveJDBCStatement) {
            HiveJDBCStatement hiveJDBCStatement = (HiveJDBCStatement)iStatement;
            hiveJDBCStatement.m_statementType = HiveJDBCStatement.StatementType.PREPARED_STATEMENT;
            return new Hive42PreparedStatement(string, (HiveJDBCStatement)iStatement, sConnection, n);
        }
        return super.createPreparedStatement(string, iStatement, sConnection, n);
    }

    @Override
    protected SStatement createStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        if (iStatement instanceof HiveJDBCStatement) {
            HiveJDBCStatement hiveJDBCStatement = (HiveJDBCStatement)iStatement;
            hiveJDBCStatement.m_statementType = HiveJDBCStatement.StatementType.STATEMENT;
            return new Hive42Statement((HiveJDBCStatement)iStatement, sConnection, n);
        }
        return super.createStatement(iStatement, sConnection, n);
    }
}

