/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.jdbc;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.dsi.exceptions.OperationCanceledException;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.HS2Client;
import com.databricks.client.hivecommon.api.HS2ClientWrapper;
import com.databricks.client.hivecommon.api.HiveExecutionContext;
import com.databricks.client.hivecommon.api.HiveOperationContext;
import com.databricks.client.hivecommon.api.HiveServer2BaseBuffer;
import com.databricks.client.hivecommon.api.RowsetBuffer;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.CommonTestProperty;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TRowSet;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowBatch;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.databricks.client.spark.api.SparkHS2OAuthClientWrapper;
import com.databricks.client.spark.arrow.ArrowBuffer;
import com.databricks.client.spark.jdbc.DownloadableExecutionContext;
import com.databricks.client.spark.jdbc.ResultFileDownloadManager;
import com.databricks.client.spark.jdbc.ResultFileDownloadMonitor;
import com.databricks.client.spark.jdbc.SparkJDBC42Driver;
import com.databricks.client.spark.jdbc.UCVolumeIngestionManager;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.Serializable;
import java.util.List;

public class DownloadableFetchClient
extends HS2Client {
    private final int RESULT_SET_TEST_LIMIT = 10;
    private ResultFileDownloadManager m_resultFileDownloadManager;
    public static final int STAGING_OPERATION_INDEX = 0;
    public static final String STAGING_OPERATION_REMOVE = "REMOVE";

    public DownloadableFetchClient(HiveJDBCSettings hiveJDBCSettings, TProtocol tProtocol, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        super(hiveJDBCSettings, tProtocol, iLogger, iWarningListener);
    }

    @Override
    public void disconnect() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            super.disconnect();
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        finally {
            this.unregisterClient();
        }
    }

    @Override
    public void fetchNRows(HiveOperationContext hiveOperationContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer, int n) throws ErrorException, OperationCanceledException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        rowsetBuffer.m_bufferHasMoreRows = true;
        if (!hiveOperationContext.m_isServerReturnedResultLinks) {
            int n2;
            this.fetchFromServer(hiveOperationContext, rowsetBuffer, n);
            if (!hiveOperationContext.m_isServerReturnedResultLinks) {
                if (rowsetBuffer.m_bufferHasMoreRows) {
                    hiveOperationContext.m_hasOpenOperation = true;
                }
                if (!hiveOperationContext.m_serverHasMoreRows) {
                    this.closeOperation(hiveOperationContext);
                }
                return;
            }
            if (null == this.m_resultFileDownloadManager) {
                this.m_resultFileDownloadManager = ((SparkJDBC42Driver)DSIDriverSingleton.getInstance()).getResultFileDownloadManager(this);
            }
            this.m_resultFileDownloadManager.addFileLinks((DownloadableExecutionContext)hiveOperationContext, rowsetBuffer.getBuffer().m_hiveServer2Buffer.getResults().getResultLinks());
            if (this.m_settings.m_commonTestProperty == CommonTestProperty.EnableTestResultFileListLimit && (n2 = ResultFileDownloadMonitor.getResultFileDownloadMonitor().getRequestListSize()) > 10) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.RESULT_FILE_LIST_TEST.name(), String.valueOf(n2));
                throw errorException;
            }
        }
        if (hiveOperationContext.m_settings.m_downloadableResultSettings.m_isSslRequiredForQueryResultDownload && (null == hiveOperationContext.m_settings.m_serverSSLSettings || !hiveOperationContext.m_settings.m_serverSSLSettings.m_enableSSL)) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FILE_DOWNLOAD_SSL_NOT_ENABLED.name());
            throw errorException;
        }
        DownloadableExecutionContext downloadableExecutionContext = (DownloadableExecutionContext)hiveOperationContext;
        while (this.m_resultFileDownloadManager.getNextDownloadedFile(downloadableExecutionContext, rowsetBuffer)) {
            if (!downloadableExecutionContext.m_downloadNeedRetry && !downloadableExecutionContext.m_serverHasMoreRows) {
                rowsetBuffer.m_bufferHasMoreRows = false;
                this.closeOperation(downloadableExecutionContext);
                return;
            }
            this.fetchFromServer(hiveOperationContext, rowsetBuffer, n);
            hiveOperationContext.m_serverHasMoreRows = this.correctHasMoreRowsResult() ? rowsetBuffer.getBuffer().m_hiveServer2Buffer.isHasMoreRows() : rowsetBuffer.m_bufferHasMoreRows;
            this.m_resultFileDownloadManager.addFileLinks(downloadableExecutionContext, rowsetBuffer.getBuffer().m_hiveServer2Buffer.getResults().getResultLinks());
            if (!downloadableExecutionContext.m_downloadNeedRetry || hiveOperationContext.m_settings.m_downloadableResultSettings.m_downloadRetryWaitTime <= 0) continue;
            try {
                Thread.sleep(hiveOperationContext.m_settings.m_downloadableResultSettings.m_downloadRetryWaitTime);
            }
            catch (InterruptedException interruptedException) {
                LogUtilities.logWarning("Got an exception while waiting for retry: " + interruptedException.getMessage(), this.m_logger);
            }
        }
        rowsetBuffer.m_bufferHasMoreRows = 0 < rowsetBuffer.getNumRows();
    }

    @Override
    protected ErrorException handleTTransportException(TTransportException tTransportException, String string) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.unregisterClient();
        return super.handleTTransportException(tTransportException, string);
    }

    @Override
    protected HiveExecutionContext createExecutionContext() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return new DownloadableExecutionContext(this.m_settings);
    }

    private void unregisterClient() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (DSIDriverSingleton.getInstance() instanceof SparkJDBC42Driver) {
            SparkJDBC42Driver sparkJDBC42Driver = (SparkJDBC42Driver)DSIDriverSingleton.getInstance();
            if (ResultFileDownloadManager.isResultDownloadManagerCreated()) {
                ResultFileDownloadManager resultFileDownloadManager = sparkJDBC42Driver.getResultFileDownloadManager(this);
                resultFileDownloadManager.unregisterClient(this);
            }
        }
    }

    @Override
    protected HS2ClientWrapper fetchOauthClientWrapper(TProtocol tProtocol, ILogger iLogger) throws ErrorException {
        return new SparkHS2OAuthClientWrapper(tProtocol, iLogger, this.m_settings, this.m_telemetryManager);
    }

    @Override
    public void handleUCVolumeIngestionFlow(HiveOperationContext hiveOperationContext) throws ErrorException {
        if (this.m_settings.m_useNativeQuery && hiveOperationContext.m_isStagingOperation) {
            Object object;
            Serializable serializable;
            TRowSet tRowSet = null;
            if (hiveOperationContext.m_executeResponse.isSetDirectResults() && hiveOperationContext.m_executeResponse.getDirectResults().isSetResultSet()) {
                tRowSet = hiveOperationContext.m_executeResponse.getDirectResults().getResultSet().getResults();
            } else {
                serializable = hiveOperationContext.m_fetchResultsReq;
                serializable.setMaxRows(this.m_settings.m_rowsFetchedPerBlock);
                serializable.setMaxBytes(this.m_settings.m_arrowMaxBytesPerFetch);
                try {
                    object = this.m_client.FetchResults((TFetchResultsReq)serializable);
                    tRowSet = ((TFetchResultsResp)object).getResults();
                }
                catch (TException tException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), tException.getMessage());
                    errorException.initCause(tException);
                    throw errorException;
                }
            }
            if (tRowSet == null || tRowSet.getArrowBatches() == null || tRowSet.getArrowBatches().size() == 0) {
                serializable = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), new String(" Direct Result returned No Arrow rows. Make sure EnableArrow is set to 1. "));
                throw serializable;
            }
            serializable = tRowSet.getArrowBatches().get(0);
            object = new ArrowBuffer(this.m_logger, hiveOperationContext.m_rsMdColumns, hiveOperationContext.m_isLz4Compressed, this.m_settings);
            ((ArrowBuffer)object).deserializeBatch((TSparkArrowBatch)serializable);
            List<String> list = ((ArrowBuffer)object).getUCVolIngestionOpDetails();
            UCVolumeIngestionManager uCVolumeIngestionManager = new UCVolumeIngestionManager(this.m_logger, this.m_settings);
            String string = list.get(0);
            if (!(this.m_settings.m_stagingAllowedLocalPaths != null && this.m_settings.m_stagingAllowedLocalPaths.size() != 0 || string.equalsIgnoreCase(STAGING_OPERATION_REMOVE))) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INVALID_STAGING_ALLOWED_LOCAL_PATHS_UC_INGESTION.name());
                throw errorException;
            }
            if (list.size() >= 3) {
                uCVolumeIngestionManager.performOperations(list);
                hiveOperationContext.m_telemetryContext.m_volume_operation_type = list.size() > 0 ? list.get(0) : null;
                hiveOperationContext.m_telemetryContext.m_volume_path = list.size() > 3 ? list.get(3) : null;
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), new String("Staging operation details are not sufficient to send the HTTP request ."));
                throw errorException;
            }
        }
    }
}

