/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl;

import com.databricks.client.jdbc42.internal.nimbusjose.CompressionAlgorithm;
import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWEHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.jcip.ThreadSafe;
import com.databricks.client.jdbc42.internal.nimbusjose.util.DeflateUtils;

@ThreadSafe
public class DeflateHelper {
    public static byte[] applyCompression(JWEHeader jweHeader, byte[] bytes) throws JOSEException {
        CompressionAlgorithm compressionAlg = jweHeader.getCompressionAlgorithm();
        if (compressionAlg == null) {
            return bytes;
        }
        if (compressionAlg.equals(CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.compress(bytes);
            }
            catch (Exception e) {
                throw new JOSEException("Couldn't compress plain text: " + e.getMessage(), e);
            }
        }
        throw new JOSEException("Unsupported compression algorithm: " + compressionAlg);
    }

    public static byte[] applyDecompression(JWEHeader jweHeader, byte[] bytes) throws JOSEException {
        CompressionAlgorithm compressionAlg = jweHeader.getCompressionAlgorithm();
        if (compressionAlg == null) {
            return bytes;
        }
        if (compressionAlg.equals(CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.decompress(bytes);
            }
            catch (Exception e) {
                throw new JOSEException("Couldn't decompress plain text: " + e.getMessage(), e);
            }
        }
        throw new JOSEException("Unsupported compression algorithm: " + compressionAlg);
    }
}

