/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.utilities;

import com.databricks.client.dsi.core.utilities.OdbcContext;
import com.databricks.client.dsi.utilities.CppEncodingType;
import java.nio.charset.Charset;

public final class CppOdbcContext
extends OdbcContext
implements AutoCloseable {
    private long m_objRef;
    private final Object m_lock = new Object();

    public CppOdbcContext(long l) {
        if (l == 0L) {
            throw new NullPointerException();
        }
        this.m_objRef = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_objRef = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Charset getSqlCCharEncoding() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.doGetSqlCCharEncoding(this.getPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getSqlCCharMaxCodepointSize() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.doGetSqlCCharMaxCodepointSize(this.getPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Charset getSqlCWCharEncoding() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.doGetSqlCWCharEncoding(this.getPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getSqlCWCharMaxCodepointSize() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.doGetSqlCWCharMaxCodepointSize(this.getPtr());
        }
    }

    private long getPtr() {
        if (this.m_objRef == 0L) {
            throw new NullPointerException();
        }
        return this.m_objRef;
    }

    private static Charset encodingTypeToCharset(int n) {
        CppEncodingType cppEncodingType = CppEncodingType.getEncoding(n);
        return cppEncodingType == null ? null : cppEncodingType.getCharset();
    }

    private native Charset doGetSqlCCharEncoding(long var1);

    private native byte doGetSqlCCharMaxCodepointSize(long var1);

    private native Charset doGetSqlCWCharEncoding(long var1);

    private native byte doGetSqlCWCharMaxCodepointSize(long var1);
}

