/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

@Deprecated
public abstract class DateJDBCDataSink
extends ConvertingJDBCDataSink {
    public DateJDBCDataSink(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    protected final void handleConversionResult(Object object, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, string);
            }
        }
    }

    protected abstract void doSet(Date var1, Calendar var2) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object != null && !(object instanceof Date)) {
            throw new IncorrectTypeException();
        }
        this.doSet((Date)object, this.getLocalCalendarForConversions());
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 91: 
            case 93: 
            case 2000: {
                this.doSet(null, null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            Date date = NonTrivialJDBCConversions.stringToDate(string, this.getLocalCalendarForConversions(), this.getAndClearListener());
            this.handleConversionResult(string, "setString");
            this.setDate(date, this.getLocalCalendarForConversions());
        }
    }

    @Override
    public void setDate(Date date, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        this.doSet(date, calendar);
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        Date date = NonTrivialJDBCConversions.timestampToDate(timestamp, calendar);
        if (timestamp.getTime() != date.getTime()) {
            this.onFractionalTruncation(timestamp, 0, "setTimestamp");
        }
        this.doSet(date, calendar);
    }
}

