/*
 * Decompiled with CFR 0.152.
 */
package com.dasu.blur.process;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.Type;
import com.dasu.blur.process.BlurProcess;

public class RSBlurProcess
implements BlurProcess {
    public static final String TAG = "RSBlurProcess";
    private final Context context;

    public RSBlurProcess(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=18)
    public Bitmap blur(Bitmap original, float radius) {
        RenderScript rs = null;
        try {
            rs = RenderScript.create((Context)this.context);
            rs.setMessageHandler(new RenderScript.RSMessageHandler());
            Allocation input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)original, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Allocation output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            ScriptIntrinsicBlur blur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            blur.setInput(input);
            blur.setRadius(radius);
            blur.forEach(output);
            output.copyTo(original);
        }
        finally {
            if (rs != null) {
                rs.destroy();
            }
        }
        return original;
    }

    public String toString() {
        return TAG;
    }
}

