/*
 * Decompiled with CFR 0.152.
 */
package com.dasu.blur;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.SystemClock;
import android.util.Log;
import com.dasu.blur.BlurConfig;
import com.dasu.blur.OnBlurListener;
import com.dasu.blur.process.BlurProcess;
import com.dasu.blur.process.JavaBlurProcess;
import com.dasu.blur.process.NativeBlurProcess;
import com.dasu.blur.process.RSBlurProcess;
import com.dasu.blur.process.StackBlurProcess;
import java.lang.ref.WeakReference;

class BlurTask
implements Runnable {
    private BlurConfig mBlurConfig;
    private OnBlurListener mBlurListener;

    public BlurTask(BlurConfig blurConfig, OnBlurListener listener) {
        this.mBlurConfig = blurConfig;
        this.mBlurListener = listener;
    }

    @Override
    public void run() {
        block6: {
            try {
                Bitmap bitmap = this.exec();
                if (bitmap != null) {
                    if (this.mBlurListener != null) {
                        this.mBlurListener.onBlurSuccess(bitmap);
                    }
                } else if (this.mBlurListener != null) {
                    this.mBlurListener.onBlurFailed();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mBlurListener == null) break block6;
                this.mBlurListener.onBlurFailed();
            }
        }
    }

    public Bitmap exec() {
        BlurProcess blurProcess;
        long time = SystemClock.uptimeMillis();
        if (this.isEmptyBitmap(this.mBlurConfig.bitmap)) {
            Log.e((String)"DBlur", (String)"BlurTask doBlur error, cause bitmap is empty");
            return null;
        }
        Bitmap source = (Bitmap)this.mBlurConfig.bitmap.get();
        int width = this.mBlurConfig.width / this.mBlurConfig.sampling;
        int height = this.mBlurConfig.height / this.mBlurConfig.sampling;
        if (this.hasZero(width, height)) {
            Log.e((String)"DBlur", (String)"doBlur error, cause mBlurConfig.width/height is 0");
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.mBlurConfig.sampling, 1.0f / (float)this.mBlurConfig.sampling);
        Paint paint = new Paint();
        paint.setFlags(3);
        PorterDuffColorFilter filter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_ATOP);
        paint.setColorFilter((ColorFilter)filter);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        switch (this.mBlurConfig.mode) {
            case 2: {
                blurProcess = new JavaBlurProcess();
                Log.w((String)"DBlur", (String)"BlurTask begin blur, u choose the mode: MODE_JAVA");
                break;
            }
            case 1: {
                blurProcess = new NativeBlurProcess();
                Log.w((String)"DBlur", (String)"BlurTask begin blur, u choose the mode: MODE_NATIVE");
                break;
            }
            case 3: {
                blurProcess = new StackBlurProcess();
                Log.w((String)"DBlur", (String)"BlurTask begin blur, u choose the mode: MODE_STACK");
                break;
            }
            case 0: {
                if (this.mBlurConfig.context != null && this.mBlurConfig.context.get() != null) {
                    blurProcess = new RSBlurProcess((Context)this.mBlurConfig.context.get());
                    Log.w((String)"DBlur", (String)"BlurTask begin blur, u choose the mode: MODE_RS");
                    break;
                }
                blurProcess = new StackBlurProcess();
                Log.w((String)"DBlur", (String)"BlurTask begin blur, u choose the mode: MODE_RS, but context is null, so change ues MODE_STACK");
                break;
            }
            default: {
                blurProcess = new StackBlurProcess();
                Log.w((String)"DBlur", (String)"BlurTask begin blur, u choose the default mode: MODE_STACK");
            }
        }
        bitmap = blurProcess.blur(bitmap, this.mBlurConfig.radius);
        if (this.mBlurConfig.sampling == 1) {
            Log.w((String)"DBlur", (String)("BlurTask finish blur, cast " + (SystemClock.uptimeMillis() - time) + "ms"));
            return bitmap;
        }
        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mBlurConfig.width, (int)this.mBlurConfig.height, (boolean)true);
        Log.w((String)"DBlur", (String)("BlurTask finish blur, cast " + (SystemClock.uptimeMillis() - time) + "ms"));
        bitmap.recycle();
        bitmap = null;
        return scaled;
    }

    private boolean hasZero(int ... args) {
        for (int num : args) {
            if (num != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyBitmap(WeakReference<Bitmap> src) {
        return src == null || src.get() == null || ((Bitmap)src.get()).getWidth() == 0 || ((Bitmap)src.get()).getHeight() == 0;
    }
}

