/*
 * Decompiled with CFR 0.152.
 */
package com.dasu.blur;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.LruCache;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.dasu.blur.BlurConfig;
import com.dasu.blur.BlurTask;
import com.dasu.blur.OnBlurListener;
import com.dasu.blur.process.ThreadManager;
import java.lang.ref.WeakReference;

class BlurHelper {
    private static LruCache<String, WeakReference<Bitmap>> sBitmapCaches = new LruCache(5);
    private static Handler sUiHandler = new Handler(Looper.getMainLooper());

    BlurHelper() {
    }

    static void doBlur(final BlurConfig blurConfig, final OnBlurListener listener) {
        ThreadManager.execTask(new Runnable(){

            @Override
            public void run() {
                BlurHelper.calculateSourceBitmap(blurConfig);
                BlurTask blurTask = new BlurTask(blurConfig, new OnBlurListener(){

                    @Override
                    public void onBlurSuccess(final Bitmap bitmap) {
                        sUiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                BlurHelper.autoHandleSuccess(bitmap, blurConfig);
                                if (listener != null) {
                                    listener.onBlurSuccess(bitmap);
                                }
                            }
                        });
                    }

                    @Override
                    public void onBlurFailed() {
                        sUiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (listener != null) {
                                    listener.onBlurFailed();
                                }
                            }
                        });
                    }
                });
                ThreadManager.execTask(blurTask);
            }
        });
    }

    private static void autoHandleSuccess(Bitmap bitmap, BlurConfig blurConfig) {
        if (blurConfig.cache && !TextUtils.isEmpty((CharSequence)blurConfig.cacheKey)) {
            BlurHelper.addCacheBitmap(blurConfig.cacheKey, bitmap);
        }
        if (blurConfig.targetView != null && blurConfig.targetView.get() != null) {
            View target = (View)blurConfig.targetView.get();
            if (target instanceof ImageView) {
                ((ImageView)target).setImageBitmap(bitmap);
            } else {
                BitmapDrawable drawable = new BitmapDrawable(target.getContext().getResources(), bitmap);
                target.setBackground((Drawable)drawable);
            }
            if (blurConfig.animAlpha) {
                BlurHelper.animate(target, blurConfig.animDuration);
            }
        }
    }

    static Bitmap doBlurSync(BlurConfig blurConfig) {
        BlurHelper.calculateSourceBitmap(blurConfig);
        BlurTask blurTask = new BlurTask(blurConfig, null);
        Bitmap bitmap = blurTask.exec();
        BlurHelper.autoHandleSuccess(bitmap, blurConfig);
        return bitmap;
    }

    private static void calculateSourceBitmap(BlurConfig blurConfig) {
        Bitmap bitmap = null;
        if (blurConfig.source != null && blurConfig.source.get() != null) {
            switch (blurConfig.sourceType) {
                case 1: {
                    bitmap = BlurHelper.getViewBitmap(((Activity)blurConfig.source.get()).getWindow().getDecorView().getRootView());
                    break;
                }
                case 2: {
                    bitmap = BlurHelper.getViewBitmap((View)blurConfig.source.get());
                    break;
                }
                case 3: {
                    bitmap = (Bitmap)blurConfig.source.get();
                }
            }
        }
        if (bitmap != null) {
            blurConfig.bitmap = new WeakReference<Object>(bitmap);
        }
    }

    private static Bitmap getViewBitmap(View view) {
        long startTime = SystemClock.uptimeMillis();
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        long endTime = SystemClock.uptimeMillis();
        Log.w((String)"DBlur", (String)("BlurHelper call view.draw() for get view's bitmap, cast " + (endTime - startTime) + "ms"));
        return bitmap;
    }

    private static void animate(View v, int duration) {
        AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
        alpha.setDuration((long)duration);
        v.startAnimation((Animation)alpha);
    }

    static Bitmap getCacheBitmap(String cacheKey) {
        WeakReference weakReference = (WeakReference)sBitmapCaches.get((Object)cacheKey);
        if (weakReference != null && weakReference.get() != null) {
            Bitmap bitmap = (Bitmap)weakReference.get();
            sBitmapCaches.remove((Object)cacheKey);
            return bitmap;
        }
        return null;
    }

    static void addCacheBitmap(String cacheKey, Bitmap bitmap) {
        if (sBitmapCaches.get((Object)cacheKey) == null) {
            WeakReference<Bitmap> weakReference = new WeakReference<Bitmap>(bitmap);
            sBitmapCaches.put((Object)cacheKey, weakReference);
        }
    }

    static Bitmap getBitmap(@NonNull Context context, @DrawableRes int resId) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)resId);
        Canvas canvas = new Canvas();
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas.setBitmap(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }
}

