/*
 * Decompiled with CFR 0.152.
 */
package com.dasu.blur;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import com.dasu.blur.BlurHelper;
import com.dasu.blur.OnBlurListener;
import java.lang.ref.WeakReference;

public class BlurConfig {
    public static final int MODE_RS = 0;
    public static final int MODE_NATIVE = 1;
    public static final int MODE_JAVA = 2;
    public static final int MODE_STACK = 3;
    static final int SOURCE_INVALID = -1;
    static final int SOURCE_ACTIVITY = 1;
    static final int SOURCE_VIEW = 2;
    static final int SOURCE_BITMAP = 3;
    private static final int DEFAULT_RADIUS = 4;
    private static final int DEFAULT_SAMPLING = 8;
    int mode = 0;
    WeakReference<Bitmap> bitmap;
    int radius = 4;
    int sampling = 8;
    boolean cache = false;
    String cacheKey;
    WeakReference<View> targetView;
    boolean animAlpha = false;
    int animDuration = 300;
    WeakReference<Context> context;
    OnBlurListener onBlurListener;
    int sourceType = -1;
    WeakReference<Object> source;
    int width;
    int height;

    BlurConfig(int sourceType) {
        this.sourceType = sourceType;
    }

    public void doBlur() {
        this.doBlur(null);
    }

    public void doBlur(OnBlurListener listener) {
        BlurHelper.doBlur(this, listener);
    }

    public Bitmap doBlurSync() {
        return BlurHelper.doBlurSync(this);
    }

    public static class UnSupportBlurConfig
    extends RuntimeException {
        public UnSupportBlurConfig(String message) {
            super(message);
        }
    }

    public static class BlurConfigBuilder {
        private BlurConfig mBlurConfig;

        public BlurConfigBuilder(@NonNull View view) {
            this.mBlurConfig = new BlurConfig(2);
            this.mBlurConfig.context = new WeakReference<Context>(view.getContext().getApplicationContext());
            this.mBlurConfig.source = new WeakReference<View>(view);
            this.mBlurConfig.width = view.getMeasuredWidth();
            this.mBlurConfig.height = view.getMeasuredHeight();
        }

        public BlurConfigBuilder(@NonNull Context context, @NonNull Bitmap bitmap) {
            this.mBlurConfig = new BlurConfig(3);
            this.mBlurConfig.context = new WeakReference<Context>(context.getApplicationContext());
            this.mBlurConfig.source = new WeakReference<Bitmap>(bitmap);
            this.mBlurConfig.width = bitmap.getWidth();
            this.mBlurConfig.height = bitmap.getHeight();
        }

        public BlurConfigBuilder(@NonNull Activity activity) {
            this.mBlurConfig = new BlurConfig(1);
            this.mBlurConfig.context = new WeakReference<Context>(activity.getApplicationContext());
            this.mBlurConfig.source = new WeakReference<Activity>(activity);
            View view = activity.getWindow().getDecorView().getRootView();
            this.mBlurConfig.width = view.getMeasuredWidth();
            this.mBlurConfig.height = view.getMeasuredHeight();
        }

        public BlurConfigBuilder(@NonNull Context context, @DrawableRes int resId) {
            this.mBlurConfig = new BlurConfig(3);
            this.mBlurConfig.context = new WeakReference<Context>(context.getApplicationContext());
            Bitmap bitmap = BlurHelper.getBitmap(context, resId);
            this.mBlurConfig.source = new WeakReference<Bitmap>(bitmap);
            this.mBlurConfig.width = bitmap.getWidth();
            this.mBlurConfig.height = bitmap.getHeight();
        }

        public BlurConfigBuilder radius(int radius) {
            this.mBlurConfig.radius = radius;
            return this;
        }

        public BlurConfigBuilder sampling(int sampling) {
            this.mBlurConfig.sampling = sampling;
            return this;
        }

        public BlurConfigBuilder cache(String cacheKey) {
            this.mBlurConfig.cache = true;
            this.mBlurConfig.cacheKey = cacheKey;
            return this;
        }

        public BlurConfigBuilder animAlpha(int duration) {
            this.mBlurConfig.animAlpha = true;
            this.mBlurConfig.animDuration = duration;
            return this;
        }

        public BlurConfigBuilder animAlpha() {
            this.mBlurConfig.animAlpha = true;
            return this;
        }

        public BlurConfigBuilder mode(int mode) {
            this.mBlurConfig.mode = mode;
            return this;
        }

        public BlurConfigBuilder intoTarget(View targetView) {
            this.mBlurConfig.targetView = new WeakReference<View>(targetView);
            return this;
        }

        public BlurConfig build() {
            this.checkConfigValid();
            return this.mBlurConfig;
        }

        private void checkConfigValid() {
            if (this.mBlurConfig.width <= 0 || this.mBlurConfig.height <= 0) {
                throw new UnSupportBlurConfig("source width and height must be > 0");
            }
            switch (this.mBlurConfig.mode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new UnSupportBlurConfig("unknown mode: " + this.mBlurConfig.mode + ", u can go to BlurConfig check valid mode.");
                }
            }
        }
    }
}

