/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.renderscript.Script;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.FieldPacker;
import android.support.v8.renderscript.RSDriverException;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptCThunker;
import android.support.v8.renderscript.Type;
import android.util.SparseArray;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    ScriptCThunker mT;
    private final SparseArray<KernelID> mKIDs = new SparseArray();
    private final SparseArray<FieldID> mFIDs = new SparseArray();

    android.renderscript.Script getNObj() {
        return this.mT;
    }

    protected KernelID createKernelID(int slot, int sig, Element ein, Element eout) {
        KernelID k = (KernelID)this.mKIDs.get(slot);
        if (k != null) {
            return k;
        }
        if (RenderScript.isNative) {
            k = new KernelID(0, this.mRS, this, slot, sig);
            if (this.mT != null) {
                k.mN = this.mT.thunkCreateKernelID(slot, sig, ein, eout);
            }
            this.mKIDs.put(slot, (Object)k);
            return k;
        }
        int id = this.mRS.nScriptKernelIDCreate(this.getID(this.mRS), slot, sig);
        if (id == 0) {
            throw new RSDriverException("Failed to create KernelID");
        }
        k = new KernelID(id, this.mRS, this, slot, sig);
        this.mKIDs.put(slot, (Object)k);
        return k;
    }

    protected FieldID createFieldID(int slot, Element e) {
        if (RenderScript.isNative) {
            FieldID f = new FieldID(0, this.mRS, this, slot);
            if (this.mT != null) {
                f.mN = this.mT.thunkCreateFieldID(slot, e);
            }
            this.mFIDs.put(slot, (Object)f);
            return f;
        }
        FieldID f = (FieldID)this.mFIDs.get(slot);
        if (f != null) {
            return f;
        }
        int id = this.mRS.nScriptFieldIDCreate(this.getID(this.mRS), slot);
        if (id == 0) {
            throw new RSDriverException("Failed to create FieldID");
        }
        f = new FieldID(id, this.mRS, this, slot);
        this.mFIDs.put(slot, (Object)f);
        return f;
    }

    protected void invoke(int slot) {
        if (this.mT != null) {
            this.mT.thunkInvoke(slot);
            return;
        }
        this.mRS.nScriptInvoke(this.getID(this.mRS), slot);
    }

    protected void invoke(int slot, FieldPacker v) {
        if (this.mT != null) {
            this.mT.thunkInvoke(slot, v);
            return;
        }
        if (v != null) {
            this.mRS.nScriptInvokeV(this.getID(this.mRS), slot, v.getData());
        } else {
            this.mRS.nScriptInvoke(this.getID(this.mRS), slot);
        }
    }

    public void bindAllocation(Allocation va, int slot) {
        if (this.mT != null) {
            this.mT.thunkBindAllocation(va, slot);
            return;
        }
        this.mRS.validate();
        if (va != null) {
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), va.getID(this.mRS), slot);
        } else {
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), 0, slot);
        }
    }

    public void setTimeZone(String timeZone) {
        if (this.mT != null) {
            this.mT.thunkSetTimeZone(timeZone);
            return;
        }
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.getID(this.mRS), timeZone.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void forEach(int slot, Allocation ain, Allocation aout, FieldPacker v) {
        if (this.mT != null) {
            this.mT.thunkForEach(slot, ain, aout, v);
            return;
        }
        if (ain == null && aout == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        int in_id = 0;
        if (ain != null) {
            in_id = ain.getID(this.mRS);
        }
        int out_id = 0;
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        this.mRS.nScriptForEach(this.getID(this.mRS), slot, in_id, out_id, params);
    }

    protected void forEach(int slot, Allocation ain, Allocation aout, FieldPacker v, LaunchOptions sc) {
        if (this.mT != null) {
            this.mT.thunkForEach(slot, ain, aout, v, sc);
            return;
        }
        if (ain == null && aout == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        if (sc == null) {
            this.forEach(slot, ain, aout, v);
            return;
        }
        int in_id = 0;
        if (ain != null) {
            in_id = ain.getID(this.mRS);
        }
        int out_id = 0;
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        this.mRS.nScriptForEachClipped(this.getID(this.mRS), slot, in_id, out_id, params, sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend);
    }

    Script(int id, RenderScript rs) {
        super(id, rs);
    }

    public void setVar(int index, float v) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, v);
            return;
        }
        this.mRS.nScriptSetVarF(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, double v) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, v);
            return;
        }
        this.mRS.nScriptSetVarD(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, int v) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, v);
            return;
        }
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, long v) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, v);
            return;
        }
        this.mRS.nScriptSetVarJ(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, boolean v) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, v);
            return;
        }
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v ? 1 : 0);
    }

    public void setVar(int index, BaseObj o) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, o);
            return;
        }
        this.mRS.nScriptSetVarObj(this.getID(this.mRS), index, o == null ? 0 : o.getID(this.mRS));
    }

    public void setVar(int index, FieldPacker v) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, v);
            return;
        }
        this.mRS.nScriptSetVarV(this.getID(this.mRS), index, v.getData());
    }

    public void setVar(int index, FieldPacker v, Element e, int[] dims) {
        if (this.mT != null) {
            this.mT.thunkSetVar(index, v, e, dims);
            return;
        }
        this.mRS.nScriptSetVarVE(this.getID(this.mRS), index, v.getData(), e.getID(this.mRS), dims);
    }

    public static final class LaunchOptions {
        private int xstart = 0;
        private int ystart = 0;
        private int xend = 0;
        private int yend = 0;
        private int zstart = 0;
        private int zend = 0;
        private int strategy;

        public LaunchOptions setX(int xstartArg, int xendArg) {
            if (xstartArg < 0 || xendArg <= xstartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.xstart = xstartArg;
            this.xend = xendArg;
            return this;
        }

        public LaunchOptions setY(int ystartArg, int yendArg) {
            if (ystartArg < 0 || yendArg <= ystartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.ystart = ystartArg;
            this.yend = yendArg;
            return this;
        }

        public LaunchOptions setZ(int zstartArg, int zendArg) {
            if (zstartArg < 0 || zendArg <= zstartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.zstart = zstartArg;
            this.zend = zendArg;
            return this;
        }

        public int getXStart() {
            return this.xstart;
        }

        public int getXEnd() {
            return this.xend;
        }

        public int getYStart() {
            return this.ystart;
        }

        public int getYEnd() {
            return this.yend;
        }

        public int getZStart() {
            return this.zstart;
        }

        public int getZEnd() {
            return this.zend;
        }
    }

    public static class FieldBase {
        protected Element mElement;
        protected Allocation mAllocation;

        protected void init(RenderScript rs, int dimx) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1);
        }

        protected void init(RenderScript rs, int dimx, int usages) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1 | usages);
        }

        protected FieldBase() {
        }

        public Element getElement() {
            return this.mElement;
        }

        public Type getType() {
            return this.mAllocation.getType();
        }

        public Allocation getAllocation() {
            return this.mAllocation;
        }

        public void updateAllocation() {
        }
    }

    public static class Builder {
        RenderScript mRS;

        Builder(RenderScript rs) {
            this.mRS = rs;
        }
    }

    public static final class FieldID
    extends BaseObj {
        Script.FieldID mN;
        Script mScript;
        int mSlot;

        FieldID(int id, RenderScript rs, Script s, int slot) {
            super(id, rs);
            this.mScript = s;
            this.mSlot = slot;
        }
    }

    public static final class KernelID
    extends BaseObj {
        Script.KernelID mN;
        Script mScript;
        int mSlot;
        int mSig;

        KernelID(int id, RenderScript rs, Script s, int slot, int sig) {
            super(id, rs);
            this.mScript = s;
            this.mSlot = slot;
            this.mSig = sig;
        }
    }
}

