/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Byte2;
import android.support.v8.renderscript.Byte3;
import android.support.v8.renderscript.Byte4;
import android.support.v8.renderscript.Double2;
import android.support.v8.renderscript.Double3;
import android.support.v8.renderscript.Double4;
import android.support.v8.renderscript.Float2;
import android.support.v8.renderscript.Float3;
import android.support.v8.renderscript.Float4;
import android.support.v8.renderscript.Int2;
import android.support.v8.renderscript.Int3;
import android.support.v8.renderscript.Int4;
import android.support.v8.renderscript.Long2;
import android.support.v8.renderscript.Long3;
import android.support.v8.renderscript.Long4;
import android.support.v8.renderscript.Matrix2f;
import android.support.v8.renderscript.Matrix3f;
import android.support.v8.renderscript.Matrix4f;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.Short2;
import android.support.v8.renderscript.Short3;
import android.support.v8.renderscript.Short4;
import android.util.Log;

public class FieldPacker {
    private android.renderscript.FieldPacker mN;
    private final byte[] mData;
    private int mPos = 0;
    private int mLen;

    public FieldPacker(int len) {
        this.mLen = len;
        this.mData = new byte[len];
        if (RenderScript.shouldThunk()) {
            this.mN = new android.renderscript.FieldPacker(len);
        }
    }

    public void align(int v) {
        if (RenderScript.shouldThunk()) {
            this.mN.align(v);
            return;
        }
        if (v <= 0 || (v & v - 1) != 0) {
            throw new RSIllegalArgumentException("argument must be a non-negative non-zero power of 2: " + v);
        }
        while ((this.mPos & v - 1) != 0) {
            this.mData[this.mPos++] = 0;
        }
    }

    public void reset() {
        if (RenderScript.shouldThunk()) {
            this.mN.reset();
            return;
        }
        this.mPos = 0;
    }

    public void reset(int i) {
        if (RenderScript.shouldThunk()) {
            this.mN.reset(i);
            return;
        }
        if (i < 0 || i >= this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + i);
        }
        this.mPos = i;
    }

    public void skip(int i) {
        if (RenderScript.shouldThunk()) {
            this.mN.skip(i);
            return;
        }
        int res = this.mPos + i;
        if (res < 0 || res > this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + i);
        }
        this.mPos = res;
    }

    public void addI8(byte v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI8(v);
            return;
        }
        this.mData[this.mPos++] = v;
    }

    public void addI16(short v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI16(v);
            return;
        }
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public void addI32(int v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI32(v);
            return;
        }
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFF);
    }

    public void addI64(long v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI64(v);
            return;
        }
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public void addU8(short v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU8(v);
            return;
        }
        if (v < 0 || v > 255) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.mData[this.mPos++] = (byte)v;
    }

    public void addU16(int v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU16(v);
            return;
        }
        if (v < 0 || v > 65535) {
            Log.e((String)"rs", (String)("FieldPacker.addU16( " + v + " )"));
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public void addU32(long v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU32(v);
            return;
        }
        if (v < 0L || v > 0xFFFFFFFFL) {
            Log.e((String)"rs", (String)("FieldPacker.addU32( " + v + " )"));
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
    }

    public void addU64(long v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU64(v);
            return;
        }
        if (v < 0L) {
            Log.e((String)"rs", (String)("FieldPacker.addU64( " + v + " )"));
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public void addF32(float v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF32(v);
            return;
        }
        this.addI32(Float.floatToRawIntBits(v));
    }

    public void addF64(double v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF64(v);
            return;
        }
        this.addI64(Double.doubleToRawLongBits(v));
    }

    public void addObj(BaseObj obj) {
        if (RenderScript.shouldThunk()) {
            if (obj != null) {
                this.mN.addObj(obj.getNObj());
            } else {
                this.mN.addObj(null);
            }
            return;
        }
        if (obj != null) {
            this.addI32(obj.getID(null));
        } else {
            this.addI32(0);
        }
    }

    public void addF32(Float2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF32(new android.renderscript.Float2(v.x, v.y));
            return;
        }
        this.addF32(v.x);
        this.addF32(v.y);
    }

    public void addF32(Float3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF32(new android.renderscript.Float3(v.x, v.y, v.z));
            return;
        }
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
    }

    public void addF32(Float4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF32(new android.renderscript.Float4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
        this.addF32(v.w);
    }

    public void addF64(Double2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF64(new android.renderscript.Double2(v.x, v.y));
            return;
        }
        this.addF64(v.x);
        this.addF64(v.y);
    }

    public void addF64(Double3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF64(new android.renderscript.Double3(v.x, v.y, v.z));
            return;
        }
        this.addF64(v.x);
        this.addF64(v.y);
        this.addF64(v.z);
    }

    public void addF64(Double4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addF64(new android.renderscript.Double4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addF64(v.x);
        this.addF64(v.y);
        this.addF64(v.z);
        this.addF64(v.w);
    }

    public void addI8(Byte2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI8(new android.renderscript.Byte2(v.x, v.y));
            return;
        }
        this.addI8(v.x);
        this.addI8(v.y);
    }

    public void addI8(Byte3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI8(new android.renderscript.Byte3(v.x, v.y, v.z));
            return;
        }
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
    }

    public void addI8(Byte4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI8(new android.renderscript.Byte4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
        this.addI8(v.w);
    }

    public void addU8(Short2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU8(new android.renderscript.Short2(v.x, v.y));
            return;
        }
        this.addU8(v.x);
        this.addU8(v.y);
    }

    public void addU8(Short3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU8(new android.renderscript.Short3(v.x, v.y, v.z));
            return;
        }
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
    }

    public void addU8(Short4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU8(new android.renderscript.Short4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
        this.addU8(v.w);
    }

    public void addI16(Short2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI16(new android.renderscript.Short2(v.x, v.y));
            return;
        }
        this.addI16(v.x);
        this.addI16(v.y);
    }

    public void addI16(Short3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI16(new android.renderscript.Short3(v.x, v.y, v.z));
            return;
        }
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
    }

    public void addI16(Short4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI16(new android.renderscript.Short4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
        this.addI16(v.w);
    }

    public void addU16(Int2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU16(new android.renderscript.Int2(v.x, v.y));
            return;
        }
        this.addU16(v.x);
        this.addU16(v.y);
    }

    public void addU16(Int3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU16(new android.renderscript.Int3(v.x, v.y, v.z));
            return;
        }
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
    }

    public void addU16(Int4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU16(new android.renderscript.Int4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
        this.addU16(v.w);
    }

    public void addI32(Int2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI32(new android.renderscript.Int2(v.x, v.y));
            return;
        }
        this.addI32(v.x);
        this.addI32(v.y);
    }

    public void addI32(Int3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI32(new android.renderscript.Int3(v.x, v.y, v.z));
            return;
        }
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
    }

    public void addI32(Int4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI32(new android.renderscript.Int4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
        this.addI32(v.w);
    }

    public void addU32(Long2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU32(new android.renderscript.Long2(v.x, v.y));
            return;
        }
        this.addU32(v.x);
        this.addU32(v.y);
    }

    public void addU32(Long3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU32(new android.renderscript.Long3(v.x, v.y, v.z));
            return;
        }
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
    }

    public void addU32(Long4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU32(new android.renderscript.Long4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
        this.addU32(v.w);
    }

    public void addI64(Long2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI64(new android.renderscript.Long2(v.x, v.y));
            return;
        }
        this.addI64(v.x);
        this.addI64(v.y);
    }

    public void addI64(Long3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI64(new android.renderscript.Long3(v.x, v.y, v.z));
            return;
        }
        this.addI64(v.x);
        this.addI64(v.y);
        this.addI64(v.z);
    }

    public void addI64(Long4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addI64(new android.renderscript.Long4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addI64(v.x);
        this.addI64(v.y);
        this.addI64(v.z);
        this.addI64(v.w);
    }

    public void addU64(Long2 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU64(new android.renderscript.Long2(v.x, v.y));
            return;
        }
        this.addU64(v.x);
        this.addU64(v.y);
    }

    public void addU64(Long3 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU64(new android.renderscript.Long3(v.x, v.y, v.z));
            return;
        }
        this.addU64(v.x);
        this.addU64(v.y);
        this.addU64(v.z);
    }

    public void addU64(Long4 v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addU64(new android.renderscript.Long4(v.x, v.y, v.z, v.w));
            return;
        }
        this.addU64(v.x);
        this.addU64(v.y);
        this.addU64(v.z);
        this.addU64(v.w);
    }

    public void addMatrix(Matrix4f v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addMatrix(new android.renderscript.Matrix4f(v.getArray()));
            return;
        }
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public void addMatrix(Matrix3f v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addMatrix(new android.renderscript.Matrix3f(v.getArray()));
            return;
        }
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public void addMatrix(Matrix2f v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addMatrix(new android.renderscript.Matrix2f(v.getArray()));
            return;
        }
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public void addBoolean(boolean v) {
        if (RenderScript.shouldThunk()) {
            this.mN.addBoolean(v);
            return;
        }
        this.addI8((byte)(v ? 1 : 0));
    }

    public final byte[] getData() {
        if (RenderScript.shouldThunk()) {
            return this.mN.getData();
        }
        return this.mData;
    }
}

