/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.renderscript.Allocation;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.ElementThunker;
import android.support.v8.renderscript.FieldPacker;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Type;
import android.support.v8.renderscript.TypeThunker;

class AllocationThunker
extends Allocation {
    android.renderscript.Allocation mN;
    static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();

    android.renderscript.Allocation getNObj() {
        return this.mN;
    }

    static Allocation.MipmapControl convertMipmapControl(Allocation.MipmapControl mc) {
        switch (mc) {
            case MIPMAP_NONE: {
                return Allocation.MipmapControl.MIPMAP_NONE;
            }
            case MIPMAP_FULL: {
                return Allocation.MipmapControl.MIPMAP_FULL;
            }
            case MIPMAP_ON_SYNC_TO_TEXTURE: {
                return Allocation.MipmapControl.MIPMAP_ON_SYNC_TO_TEXTURE;
            }
        }
        return null;
    }

    public Type getType() {
        return TypeThunker.find(this.mN.getType());
    }

    public Element getElement() {
        return this.getType().getElement();
    }

    public int getUsage() {
        return this.mN.getUsage();
    }

    public int getBytesSize() {
        return this.mN.getBytesSize();
    }

    AllocationThunker(RenderScript rs, Type t, int usage, android.renderscript.Allocation na) {
        super(0, rs, t, usage);
        this.mType = t;
        this.mUsage = usage;
        this.mN = na;
    }

    public void syncAll(int srcLocation) {
        this.mN.syncAll(srcLocation);
    }

    public void ioSend() {
        this.mN.ioSend();
    }

    public void ioReceive() {
        this.mN.ioReceive();
    }

    public void copyFrom(BaseObj[] d) {
        if (d == null) {
            return;
        }
        android.renderscript.BaseObj[] dN = new android.renderscript.BaseObj[d.length];
        for (int i = 0; i < d.length; ++i) {
            dN[i] = d[i].getNObj();
        }
        this.mN.copyFrom(dN);
    }

    public void copyFromUnchecked(int[] d) {
        this.mN.copyFromUnchecked(d);
    }

    public void copyFromUnchecked(short[] d) {
        this.mN.copyFromUnchecked(d);
    }

    public void copyFromUnchecked(byte[] d) {
        this.mN.copyFromUnchecked(d);
    }

    public void copyFromUnchecked(float[] d) {
        this.mN.copyFromUnchecked(d);
    }

    public void copyFrom(int[] d) {
        this.mN.copyFrom(d);
    }

    public void copyFrom(short[] d) {
        this.mN.copyFrom(d);
    }

    public void copyFrom(byte[] d) {
        this.mN.copyFrom(d);
    }

    public void copyFrom(float[] d) {
        this.mN.copyFrom(d);
    }

    public void copyFrom(Bitmap b) {
        this.mN.copyFrom(b);
    }

    public void copyFrom(Allocation a) {
        AllocationThunker at = (AllocationThunker)a;
        this.mN.copyFrom(at.mN);
    }

    public void setFromFieldPacker(int xoff, FieldPacker fp) {
        android.renderscript.FieldPacker nfp = new android.renderscript.FieldPacker(fp.getData());
        this.mN.setFromFieldPacker(xoff, nfp);
    }

    public void setFromFieldPacker(int xoff, int component_number, FieldPacker fp) {
        android.renderscript.FieldPacker nfp = new android.renderscript.FieldPacker(fp.getData());
        this.mN.setFromFieldPacker(xoff, component_number, nfp);
    }

    public void generateMipmaps() {
        this.mN.generateMipmaps();
    }

    public void copy1DRangeFromUnchecked(int off, int count, int[] d) {
        this.mN.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFromUnchecked(int off, int count, short[] d) {
        this.mN.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFromUnchecked(int off, int count, byte[] d) {
        this.mN.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFromUnchecked(int off, int count, float[] d) {
        this.mN.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, int[] d) {
        this.mN.copy1DRangeFrom(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, short[] d) {
        this.mN.copy1DRangeFrom(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, byte[] d) {
        this.mN.copy1DRangeFrom(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, float[] d) {
        this.mN.copy1DRangeFrom(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, Allocation data, int dataOff) {
        AllocationThunker at = (AllocationThunker)data;
        this.mN.copy1DRangeFrom(off, count, at.mN, dataOff);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, byte[] data) {
        this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, short[] data) {
        this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, int[] data) {
        this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, float[] data) {
        this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, Allocation data, int dataXoff, int dataYoff) {
        AllocationThunker at = (AllocationThunker)data;
        this.mN.copy2DRangeFrom(xoff, yoff, w, h, at.mN, dataXoff, dataYoff);
    }

    public void copy2DRangeFrom(int xoff, int yoff, Bitmap data) {
        this.mN.copy2DRangeFrom(xoff, yoff, data);
    }

    public void copyTo(Bitmap b) {
        this.mN.copyTo(b);
    }

    public void copyTo(byte[] d) {
        this.mN.copyTo(d);
    }

    public void copyTo(short[] d) {
        this.mN.copyTo(d);
    }

    public void copyTo(int[] d) {
        this.mN.copyTo(d);
    }

    public void copyTo(float[] d) {
        this.mN.copyTo(d);
    }

    public static Allocation createTyped(RenderScript rs, Type type, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        TypeThunker tt = (TypeThunker)type;
        android.renderscript.Allocation a = android.renderscript.Allocation.createTyped((android.renderscript.RenderScript)rst.mN, (android.renderscript.Type)tt.mN, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
        return new AllocationThunker(rs, type, usage, a);
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        android.renderscript.Allocation a = android.renderscript.Allocation.createFromBitmap((android.renderscript.RenderScript)rst.mN, (Bitmap)b, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
        TypeThunker tt = new TypeThunker(rs, a.getType());
        return new AllocationThunker(rs, tt, usage, a);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        android.renderscript.Allocation a = android.renderscript.Allocation.createCubemapFromBitmap((android.renderscript.RenderScript)rst.mN, (Bitmap)b, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
        TypeThunker tt = new TypeThunker(rs, a.getType());
        return new AllocationThunker(rs, tt, usage, a);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        android.renderscript.Allocation a = android.renderscript.Allocation.createCubemapFromCubeFaces((android.renderscript.RenderScript)rst.mN, (Bitmap)xpos, (Bitmap)xneg, (Bitmap)ypos, (Bitmap)yneg, (Bitmap)zpos, (Bitmap)zneg, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
        TypeThunker tt = new TypeThunker(rs, a.getType());
        return new AllocationThunker(rs, tt, usage, a);
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        android.renderscript.Allocation a = android.renderscript.Allocation.createFromBitmapResource((android.renderscript.RenderScript)rst.mN, (Resources)res, (int)id, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
        TypeThunker tt = new TypeThunker(rs, a.getType());
        return new AllocationThunker(rs, tt, usage, a);
    }

    public static Allocation createFromString(RenderScript rs, String str, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        android.renderscript.Allocation a = android.renderscript.Allocation.createFromString((android.renderscript.RenderScript)rst.mN, (String)str, (int)usage);
        TypeThunker tt = new TypeThunker(rs, a.getType());
        return new AllocationThunker(rs, tt, usage, a);
    }

    public static Allocation createSized(RenderScript rs, Element e, int count, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        ElementThunker et = (ElementThunker)e;
        android.renderscript.Allocation a = android.renderscript.Allocation.createSized((android.renderscript.RenderScript)rst.mN, (android.renderscript.Element)((android.renderscript.Element)e.getNObj()), (int)count, (int)usage);
        TypeThunker tt = new TypeThunker(rs, a.getType());
        return new AllocationThunker(rs, tt, usage, a);
    }

    static {
        AllocationThunker.mBitmapOptions.inScaled = false;
    }
}

