/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.age;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.FaceDetector;
import com.darwin.viola.age.AgeClassificationListener;
import com.darwin.viola.age.AgeOptions;
import com.darwin.viola.age.AgeRecognition;
import com.darwin.viola.age.Classifier;
import com.darwin.viola.age.Util;
import com.darwin.viola.age.ViolaAgeClassifier;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/darwin/viola/age/ViolaAgeClassifier;", "", "listener", "Lcom/darwin/viola/age/AgeClassificationListener;", "(Lcom/darwin/viola/age/AgeClassificationListener;)V", "classifier", "Lcom/darwin/viola/age/Classifier;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "", "isInitialized", "()Z", "dispose", "", "findAgeAsync", "faceBitmap", "Landroid/graphics/Bitmap;", "options", "Lcom/darwin/viola/age/AgeOptions;", "findAgeSynchronized", "", "Lcom/darwin/viola/age/AgeRecognition;", "getDefaultAgeOptions", "initialize", "context", "Landroid/content/Context;", "resize", "image", "verifyFacePresence", "bitmap", "age_release"})
public final class ViolaAgeClassifier {
    private Classifier classifier;
    private boolean isInitialized;
    private final CoroutineScope coroutineScope;
    private final AgeClassificationListener listener;

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final void initialize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isInitialized) {
            Util.Companion.printLog("Initializing Viola age classifier.");
            Classifier.Model model = Classifier.Model.QUANTIZED_MOBILE_NET;
            Classifier.Device device = Classifier.Device.CPU;
            try {
                this.classifier = Classifier.Companion.create(context, model, device, 1);
                this.isInitialized = true;
            }
            catch (IOException e) {
                String error = "Failed to create age classifier: " + e.getClass().getCanonicalName() + '(' + e.getMessage() + ')';
                Util.Companion.printLog(error);
                this.listener.onAgeClassificationError(error);
            }
        }
    }

    public final void dispose() {
        Util.Companion.printLog("Disposing age classifier and its resources.");
        this.isInitialized = false;
        Classifier classifier = this.classifier;
        if (classifier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classifier");
        }
        classifier.close();
    }

    @JvmOverloads
    public final void findAgeAsync(@NotNull Bitmap faceBitmap, @NotNull AgeOptions options) {
        Intrinsics.checkNotNullParameter((Object)faceBitmap, (String)"faceBitmap");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Util.Companion.setDebug(options.getDebug());
        if (this.isInitialized) {
            Util.Companion.printLog("Processing face bitmap for age classification.");
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, faceBitmap, options, null){
                int label;
                final /* synthetic */ ViolaAgeClassifier this$0;
                final /* synthetic */ Bitmap $faceBitmap;
                final /* synthetic */ AgeOptions $options;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    void $result;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Bitmap resizedBitmap = ViolaAgeClassifier.access$resize(this.this$0, this.$faceBitmap);
                            Bitmap bitmap = Util.Companion.forceEvenBitmapSize(resizedBitmap);
                            Intrinsics.checkNotNull((Object)bitmap);
                            Bitmap fixedBitmap = bitmap;
                            if (this.$options.getPreValidateFace() && !ViolaAgeClassifier.access$verifyFacePresence(this.this$0, fixedBitmap)) break;
                            Ref.ObjectRef results = new Ref.ObjectRef();
                            results.element = ViolaAgeClassifier.access$getClassifier$p(this.this$0).recognizeImage(resizedBitmap, 0);
                            Util.Companion.printLog("Age classification completed, sending back the result.");
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, results, null){
                                int label;
                                final /* synthetic */ findAgeAsync.1 this$0;
                                final /* synthetic */ Ref.ObjectRef $results;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            ViolaAgeClassifier.access$getListener$p(this.this$0.this$0).onAgeClassificationResult((List)this.$results.element);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$results = objectRef;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    this.label = 2;
                    Object object4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ findAgeAsync.1 this$0;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    ViolaAgeClassifier.access$getListener$p(this.this$0.this$0).onAgeClassificationError("There is no face portraits in the given image.");
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                        {
                            this.this$0 = var1_1;
                            super(2, continuation);
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                            Intrinsics.checkNotNullParameter(completion, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            return function2;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)this);
                    if (object4 != object2) return Unit.INSTANCE;
                    return object2;
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = violaAgeClassifier;
                    this.$faceBitmap = bitmap;
                    this.$options = ageOptions;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Util.Companion.printLog("Viola age classifier is not initialized.");
            this.listener.onAgeClassificationError("Viola age classifier is not initialized.");
        }
    }

    public static /* synthetic */ void findAgeAsync$default(ViolaAgeClassifier violaAgeClassifier, Bitmap bitmap, AgeOptions ageOptions, int n, Object object) {
        if ((n & 2) != 0) {
            ageOptions = violaAgeClassifier.getDefaultAgeOptions();
        }
        violaAgeClassifier.findAgeAsync(bitmap, ageOptions);
    }

    @JvmOverloads
    public final void findAgeAsync(@NotNull Bitmap faceBitmap) {
        ViolaAgeClassifier.findAgeAsync$default(this, faceBitmap, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final List<AgeRecognition> findAgeSynchronized(@NotNull Bitmap faceBitmap, @NotNull AgeOptions options) throws IllegalStateException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)faceBitmap, (String)"faceBitmap");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Util.Companion.setDebug(options.getDebug());
        if (this.isInitialized) {
            Util.Companion.printLog("Processing face bitmap in synchronized manner for age classification.");
            Bitmap resizedBitmap = this.resize(faceBitmap);
            Bitmap bitmap = Util.Companion.forceEvenBitmapSize(resizedBitmap);
            Intrinsics.checkNotNull((Object)bitmap);
            Bitmap fixedBitmap = bitmap;
            if (options.getPreValidateFace() && !this.verifyFacePresence(fixedBitmap)) {
                throw (Throwable)new IllegalArgumentException("There is no face portraits in the given image.");
            }
            Classifier classifier = this.classifier;
            if (classifier == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classifier");
            }
            return classifier.recognizeImage(resizedBitmap, 0);
        }
        Util.Companion.printLog("Viola age classifier is not initialized. Throwing exception.");
        throw (Throwable)new IllegalStateException("Viola age classifier is not initialized.");
    }

    public static /* synthetic */ List findAgeSynchronized$default(ViolaAgeClassifier violaAgeClassifier, Bitmap bitmap, AgeOptions ageOptions, int n, Object object) throws IllegalStateException, IllegalArgumentException {
        if ((n & 2) != 0) {
            ageOptions = violaAgeClassifier.getDefaultAgeOptions();
        }
        return violaAgeClassifier.findAgeSynchronized(bitmap, ageOptions);
    }

    @JvmOverloads
    @NotNull
    public final List<AgeRecognition> findAgeSynchronized(@NotNull Bitmap faceBitmap) throws IllegalStateException, IllegalArgumentException {
        return ViolaAgeClassifier.findAgeSynchronized$default(this, faceBitmap, null, 2, null);
    }

    private final AgeOptions getDefaultAgeOptions() {
        return new AgeOptions.Builder().build();
    }

    private final boolean verifyFacePresence(Bitmap bitmap) {
        Bitmap bitmap2 = bitmap.copy(Bitmap.Config.RGB_565, true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap.copy(Bitmap.Config.RGB_565, true)");
        Bitmap pBitmap = bitmap2;
        FaceDetector faceDetector = new FaceDetector(pBitmap.getWidth(), pBitmap.getHeight(), 1);
        FaceDetector.Face[] faceArray = new FaceDetector.Face[1];
        int faceCount = faceDetector.findFaces(pBitmap, faceArray);
        return faceCount != 0;
    }

    private final Bitmap resize(Bitmap image) {
        Util.Companion.printLog("Re-scaling input bitmap for fast image processing.");
        int maxWidth = 300;
        int maxHeight = 400;
        int width = image.getWidth();
        int height = image.getHeight();
        float ratioBitmap = (float)width / (float)height;
        float ratioMax = (float)maxWidth / (float)maxHeight;
        int finalWidth = maxWidth;
        int finalHeight = maxHeight;
        if (ratioMax > ratioBitmap) {
            finalWidth = (int)((float)maxHeight * ratioBitmap);
        } else {
            finalHeight = (int)((float)maxWidth / ratioBitmap);
        }
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)finalWidth, (int)finalHeight, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026Width, finalHeight, true)");
        return bitmap;
    }

    public ViolaAgeClassifier(@NotNull AgeClassificationListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    public static final /* synthetic */ Bitmap access$resize(ViolaAgeClassifier $this, Bitmap image) {
        return $this.resize(image);
    }

    public static final /* synthetic */ boolean access$verifyFacePresence(ViolaAgeClassifier $this, Bitmap bitmap) {
        return $this.verifyFacePresence(bitmap);
    }

    public static final /* synthetic */ Classifier access$getClassifier$p(ViolaAgeClassifier $this) {
        Classifier classifier = $this.classifier;
        if (classifier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classifier");
        }
        return classifier;
    }

    public static final /* synthetic */ void access$setClassifier$p(ViolaAgeClassifier $this, Classifier classifier) {
        $this.classifier = classifier;
    }

    public static final /* synthetic */ AgeClassificationListener access$getListener$p(ViolaAgeClassifier $this) {
        return $this.listener;
    }
}

