/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.swipe.implments;

import android.view.View;
import android.widget.BaseAdapter;
import com.daimajia.swipe.SimpleSwipeListener;
import com.daimajia.swipe.SwipeLayout;
import com.daimajia.swipe.interfaces.SwipeAdapterInterface;
import com.daimajia.swipe.interfaces.SwipeItemMangerInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SwipeItemMangerImpl
implements SwipeItemMangerInterface {
    private Mode mode = Mode.Single;
    public final int INVALID_POSITION = -1;
    protected int mOpenPosition = -1;
    protected Set<Integer> mOpenPositions = new HashSet<Integer>();
    protected Set<SwipeLayout> mShownLayouts = new HashSet<SwipeLayout>();
    protected BaseAdapter mAdapter;

    public SwipeItemMangerImpl(BaseAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter can not be null");
        }
        if (!(adapter instanceof SwipeItemMangerInterface)) {
            throw new IllegalArgumentException("adapter should implement the SwipeAdapterInterface");
        }
        this.mAdapter = adapter;
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Mode mode) {
        this.mode = mode;
        this.mOpenPositions.clear();
        this.mShownLayouts.clear();
        this.mOpenPosition = -1;
    }

    public void initialize(View target, int position) {
        int resId = this.getSwipeLayoutId(position);
        OnLayoutListener onLayoutListener = new OnLayoutListener(position);
        SwipeLayout swipeLayout = (SwipeLayout)target.findViewById(resId);
        if (swipeLayout == null) {
            throw new IllegalStateException("can not find SwipeLayout in target view");
        }
        SwipeMemory swipeMemory = new SwipeMemory(position);
        swipeLayout.addSwipeListener(swipeMemory);
        swipeLayout.addOnLayoutListener(onLayoutListener);
        swipeLayout.setTag(resId, new ValueBox(position, swipeMemory, onLayoutListener));
        this.mShownLayouts.add(swipeLayout);
    }

    public void updateConvertView(View target, int position) {
        int resId = this.getSwipeLayoutId(position);
        SwipeLayout swipeLayout = (SwipeLayout)target.findViewById(resId);
        if (swipeLayout == null) {
            throw new IllegalStateException("can not find SwipeLayout in target view");
        }
        ValueBox valueBox = (ValueBox)swipeLayout.getTag(resId);
        valueBox.swipeMemory.setPosition(position);
        valueBox.onLayoutListener.setPosition(position);
        valueBox.position = position;
    }

    private int getSwipeLayoutId(int position) {
        return ((SwipeAdapterInterface)this.mAdapter).getSwipeLayoutResourceId(position);
    }

    @Override
    public void openItem(int position) {
        if (this.mode == Mode.Multiple) {
            if (!this.mOpenPositions.contains(position)) {
                this.mOpenPositions.add(position);
            }
        } else {
            this.mOpenPosition = position;
        }
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void closeItem(int position) {
        if (this.mode == Mode.Multiple) {
            this.mOpenPositions.remove(position);
        } else if (this.mOpenPosition == position) {
            this.mOpenPosition = -1;
        }
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void closeAllExcept(SwipeLayout layout) {
        for (SwipeLayout s : this.mShownLayouts) {
            if (s == layout) continue;
            s.close();
        }
    }

    @Override
    public void removeShownLayouts(SwipeLayout layout) {
        this.mShownLayouts.remove((Object)layout);
    }

    @Override
    public List<Integer> getOpenItems() {
        if (this.mode == Mode.Multiple) {
            return new ArrayList<Integer>(this.mOpenPositions);
        }
        return Arrays.asList(this.mOpenPosition);
    }

    @Override
    public List<SwipeLayout> getOpenLayouts() {
        return new ArrayList<SwipeLayout>(this.mShownLayouts);
    }

    @Override
    public boolean isOpen(int position) {
        if (this.mode == Mode.Multiple) {
            return this.mOpenPositions.contains(position);
        }
        return this.mOpenPosition == position;
    }

    class SwipeMemory
    extends SimpleSwipeListener {
        private int position;

        SwipeMemory(int position) {
            this.position = position;
        }

        @Override
        public void onClose(SwipeLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Mode.Multiple) {
                SwipeItemMangerImpl.this.mOpenPositions.remove(this.position);
            } else {
                SwipeItemMangerImpl.this.mOpenPosition = -1;
            }
        }

        @Override
        public void onStartOpen(SwipeLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Mode.Single) {
                SwipeItemMangerImpl.this.closeAllExcept(layout);
            }
        }

        @Override
        public void onOpen(SwipeLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Mode.Multiple) {
                SwipeItemMangerImpl.this.mOpenPositions.add(this.position);
            } else {
                SwipeItemMangerImpl.this.closeAllExcept(layout);
                SwipeItemMangerImpl.this.mOpenPosition = this.position;
            }
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    class OnLayoutListener
    implements SwipeLayout.OnLayout {
        private int position;

        OnLayoutListener(int position) {
            this.position = position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public void onLayout(SwipeLayout v) {
            if (SwipeItemMangerImpl.this.isOpen(this.position)) {
                v.open(false, false);
            } else {
                v.close(false, false);
            }
        }
    }

    class ValueBox {
        OnLayoutListener onLayoutListener;
        SwipeMemory swipeMemory;
        int position;

        ValueBox(int position, SwipeMemory swipeMemory, OnLayoutListener onLayoutListener) {
            this.swipeMemory = swipeMemory;
            this.onLayoutListener = onLayoutListener;
            this.position = position;
        }
    }

    public static enum Mode {
        Single,
        Multiple;

    }
}

