/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.audio.visualizer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.dailystudio.devbricksx.audio.R;
import com.dailystudio.devbricksx.ui.AbsSurfaceView;
import com.dailystudio.devbricksx.utils.ResourcesCompatUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0017\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 #2\u00020\u0001:\u0001#B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u00142\b\b\u0001\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0007R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/dailystudio/devbricksx/audio/visualizer/RawAudioDataVisualizer;", "Lcom/dailystudio/devbricksx/ui/AbsSurfaceView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "barColor", "barSpace", "barWidth", "frameData", "", "maxEffectiveAmplifier", "minEffectiveAmplifier", "paint", "Landroid/graphics/Paint;", "drawingCanvas", "", "canvas", "Landroid/graphics/Canvas;", "initAttrs", "setAudioFrameData", "data", "setBarColor", "color", "setBarSpace", "space", "setBarWidth", "width", "setMaxEffectiveAmplifier", "amp", "setMinEffectiveAmplifier", "Companion", "devbricksx-audio_release"})
public final class RawAudioDataVisualizer
extends AbsSurfaceView {
    private short[] frameData;
    private int barColor;
    private int barWidth;
    private int barSpace;
    private int maxEffectiveAmplifier;
    private int minEffectiveAmplifier;
    private Paint paint;
    public static final int DEFAULT_BAR_WIDTH = 25;
    public static final int DEFAULT_BAR_SPACE = 5;
    public static final int DEFAULT_MAX_EFFECTIVE_AMP = 800;
    public static final int DEFAULT_MIN_EFFECTIVE_AMP = 20;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RawAudioDataVisualizer, defStyleAttr, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026ualizer, defStyleAttr, 0)");
        TypedArray a = typedArray;
        int color2 = a.getColor(R.styleable.RawAudioDataVisualizer_barColor, ResourcesCompatUtils.INSTANCE.getColor(context, R.color.colorPrimary));
        this.setBarColor(color2);
        int width = a.getDimensionPixelSize(R.styleable.RawAudioDataVisualizer_barWidth, 25);
        this.setBarWidth(width);
        int space = a.getDimensionPixelSize(R.styleable.RawAudioDataVisualizer_barSpace, 5);
        this.setBarSpace(space);
        int maxAmp = a.getInteger(R.styleable.RawAudioDataVisualizer_maxAmplifier, 800);
        this.setMaxEffectiveAmplifier(maxAmp);
        int minAmp = a.getInteger(R.styleable.RawAudioDataVisualizer_minAmplifier, 20);
        this.setMinEffectiveAmplifier(minAmp);
        a.recycle();
    }

    public final void setAudioFrameData(@NotNull short[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.frameData = data;
    }

    public final void setBarColor(@ColorInt int color2) {
        this.barColor = color2;
    }

    public final void setBarWidth(int width) {
        this.barWidth = width;
    }

    public final void setBarSpace(int space) {
        this.barSpace = space;
    }

    public final void setMaxEffectiveAmplifier(int amp) {
        this.maxEffectiveAmplifier = amp < 1 ? 1 : amp;
    }

    public final void setMinEffectiveAmplifier(int amp) {
        this.minEffectiveAmplifier = amp < 1 ? 1 : amp;
    }

    /*
     * WARNING - void declaration
     */
    public void drawingCanvas(@NotNull Canvas canvas) {
        short[] sArray;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Paint paint = this.paint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply22 = paint;
        boolean bl3 = false;
        $this$apply22.setColor(this.barColor);
        $this$apply22.setStrokeWidth((float)this.barWidth);
        int baseline = this.getHeight() / 2;
        float f = (float)this.getWidth() / (float)(this.barWidth + this.barSpace);
        boolean $this$apply22 = false;
        int filteredCount = (int)Math.ceil(f);
        short[] rawData = this.frameData;
        if (rawData != null) {
            float f2 = (float)rawData.length / (float)filteredCount;
            n = 0;
            int filterBufferSize = (int)Math.floor(f2);
            if (rawData.length % filteredCount != 0) {
                ++filteredCount;
            }
            short[] sArray2 = new short[filteredCount];
            n = 0;
            boolean bl4 = false;
            short[] $this$apply = sArray2;
            boolean bl5 = false;
            int average = 0;
            int count = 0;
            int n2 = 0;
            int n3 = rawData.length;
            while (n2 < n3) {
                void i;
                if (i != false && i % filterBufferSize == false) {
                    int newAverage = average / count;
                    boolean bl6 = false;
                    int filterAverage = Math.abs(newAverage) < this.minEffectiveAmplifier ? 1 : newAverage;
                    $this$apply[i / filterBufferSize] = (short)filterAverage;
                    average = 0;
                    count = 0;
                } else {
                    average += rawData[i];
                    ++count;
                }
                ++i;
            }
            sArray = sArray2;
        } else {
            short[] filterBufferSize = new short[filteredCount];
            int n4 = 0;
            while (n4 < filteredCount) {
                short s;
                n = n4;
                int n5 = n4++;
                short[] sArray3 = filterBufferSize;
                boolean bl7 = false;
                sArray3[n5] = s = 1;
            }
            sArray = filterBufferSize;
        }
        short[] filtered = sArray;
        int filterBufferSize = 0;
        int n6 = filtered.length;
        while (filterBufferSize < n6) {
            void i;
            short bit = filtered[i];
            int bW = this.barWidth + this.barSpace;
            float bH = (float)this.getHeight() * (float)bit / (float)this.maxEffectiveAmplifier;
            float x = (float)i * (float)bW;
            canvas.drawLine(x, (float)baseline - bH / (float)2, x, (float)baseline + bH / (float)2, this.paint);
            ++i;
        }
    }

    @JvmOverloads
    public RawAudioDataVisualizer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.barWidth = 25;
        this.barSpace = 5;
        this.maxEffectiveAmplifier = 800;
        this.minEffectiveAmplifier = 20;
        this.initAttrs(context, attrs, defStyleAttr);
        this.setFramesPerSecond(10);
        this.paint = new Paint(1);
    }

    public /* synthetic */ RawAudioDataVisualizer(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public RawAudioDataVisualizer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public RawAudioDataVisualizer(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public RawAudioDataVisualizer(@NotNull Context context) {
        this(context, null, 0, 0, 14, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/dailystudio/devbricksx/audio/visualizer/RawAudioDataVisualizer$Companion;", "", "()V", "DEFAULT_BAR_SPACE", "", "DEFAULT_BAR_WIDTH", "DEFAULT_MAX_EFFECTIVE_AMP", "DEFAULT_MIN_EFFECTIVE_AMP", "devbricksx-audio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

