/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.model.v202010;

import com.dahuatech.icc.oauth.model.v202010.HttpConfigInfo;
import com.dahuatech.icc.oauth.profile.GrantType;

public abstract class OauthConfigBaseInfo {
    protected String clientId;
    protected String clientSecret;
    protected GrantType grantType;
    protected HttpConfigInfo httpConfigInfo;

    public OauthConfigBaseInfo() {
    }

    public OauthConfigBaseInfo(String host, String clientId, String clientSecret, GrantType grantType) {
        this.httpConfigInfo = new HttpConfigInfo(host);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.grantType = grantType;
    }

    public OauthConfigBaseInfo(String host, String clientId, String clientSecret, GrantType grantType, boolean isEnableHttpTest, String httpsPort, String httpPort) {
        this(host, clientId, clientSecret, grantType);
        this.httpConfigInfo = new HttpConfigInfo(host, isEnableHttpTest, httpsPort, httpPort);
    }

    public OauthConfigBaseInfo(String host, String clientId, String clientSecret, GrantType grantType, boolean isEnableHttpTest, String port) {
        this(host, clientId, clientSecret, grantType);
        this.httpConfigInfo = isEnableHttpTest ? new HttpConfigInfo(host, true, null, port) : new HttpConfigInfo(host, false, port, null);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public HttpConfigInfo getHttpConfigInfo() {
        return this.httpConfigInfo;
    }

    public void setHttpConfigInfo(HttpConfigInfo httpConfigInfo) {
        this.httpConfigInfo = httpConfigInfo;
    }
}

