/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.model.v202010;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.common.ParamValidEnum;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.constant.OauthConstant;
import com.dahuatech.icc.oauth.exception.BusinessException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;
import com.dahuatech.icc.oauth.model.v202010.BrmKeepAliveResponse;
import com.dahuatech.icc.oauth.model.v202010.HttpConfigInfo;
import com.dahuatech.icc.util.StringUtils;

public class BrmKeepAliveRequest
extends AbstractIccRequest<BrmKeepAliveResponse> {
    private Integer clientType;
    private String magicId;

    public BrmKeepAliveRequest() throws ClientException {
        super(OauthConstant.brmUrl("/evo-apigw/evo-brm/%s/user/keepalive"), Method.POST);
    }

    public BrmKeepAliveRequest(HttpConfigInfo httpConfigInfo) throws ClientException {
        super(OauthConstant.brmUrl(httpConfigInfo, "/evo-apigw/evo-brm/%s/user/keepalive"), Method.POST);
    }

    @Override
    public Class<BrmKeepAliveResponse> getResponseClass() {
        return BrmKeepAliveResponse.class;
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
        this.putBodyParameter("clientType", clientType);
    }

    public String getMagicId() {
        return this.magicId;
    }

    public void setMagicId(String magicId) {
        this.magicId = magicId;
        this.putBodyParameter("magicId", magicId);
    }

    public void businessValid() {
        if (this.clientType == null) {
            throw new BusinessException(ParamValidEnum.PARAM_NOT_EMPTY_ERROR.getCode(), ParamValidEnum.PARAM_NOT_EMPTY_ERROR.getErrMsg(), "clientType");
        }
        if (StringUtils.isEmpty((String)this.magicId)) {
            throw new BusinessException(ParamValidEnum.PARAM_NOT_EMPTY_ERROR.getCode(), ParamValidEnum.PARAM_NOT_EMPTY_ERROR.getErrMsg(), "magicId");
        }
    }
}

