/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.handle;

import com.dahuatech.hutool.core.thread.NamedThreadFactory;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.constant.OauthConstant;
import com.dahuatech.icc.oauth.handle.OauthProcessor;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.model.v202010.BrmKeepAliveResponse;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigBaseInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigClientInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthRefreshTokenResponse;
import com.dahuatech.icc.oauth.profile.GrantType;
import com.dahuatech.icc.oauth.profile.IccProfile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TokenHandlerProcessor {
    private static final Log logger = LogFactory.get();
    private static final AtomicBoolean TOKEN_INITED = new AtomicBoolean(Boolean.FALSE);
    private static final long FRESH_TOKEN_INTERVAL = 30000L;
    private final ScheduledExecutorService REFRESH_TOKEN_SCHEDULED = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Icc-Refresh-Token-New", true));
    private final Map<String, IccTokenResponse.IccToken> tokenMap = new ConcurrentHashMap<String, IccTokenResponse.IccToken>();
    private final Map<String, OauthConfigBaseInfo> httpConfigMap = new ConcurrentHashMap<String, OauthConfigBaseInfo>();

    public Map<String, IccTokenResponse.IccToken> getTokenMap() {
        return this.tokenMap;
    }

    private TokenHandlerProcessor() {
        this.REFRESH_TOKEN_SCHEDULED.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    TokenHandlerProcessor.this.refreshTokenAndKeepAlive();
                }
                catch (Throwable t) {
                    logger.error("Unexpected error occur at token refresh, cause: " + t.getMessage(), new Object[]{t});
                }
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized TokenHandlerProcessor getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized IccTokenResponse.IccToken oauth(OauthConfigBaseInfo oauthConfigBaseInfo) {
        IccTokenResponse.IccToken token = null;
        try {
            token = OauthProcessor.getIntance().oauth(oauthConfigBaseInfo);
            this.httpConfigMap.put(this.getKey(oauthConfigBaseInfo), oauthConfigBaseInfo);
            this.tokenMap.put(this.getKey(oauthConfigBaseInfo), token);
        }
        catch (ClientException e) {
            logger.error("get token failure", new Object[0]);
        }
        return token;
    }

    public IccTokenResponse.IccToken getTokenCache(OauthConfigBaseInfo oauthConfigBaseInfo) {
        if (this.REFRESH_TOKEN_SCHEDULED.isShutdown() || this.REFRESH_TOKEN_SCHEDULED.isTerminated()) {
            logger.warn("\u5b9a\u65f6\u4efb\u52a1\u8fdb\u7a0b\u5f02\u5e38\u5173\u95ed\uff0c\u91cd\u65b0\u52a0\u8f7d", new Object[0]);
            this.REFRESH_TOKEN_SCHEDULED.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        TokenHandlerProcessor.this.refreshTokenAndKeepAlive();
                    }
                    catch (Throwable t) {
                        logger.error("Unexpected error occur at token refresh, cause: " + t.getMessage(), new Object[]{t});
                    }
                }
            }, 30000L, 30000L, TimeUnit.MILLISECONDS);
        }
        String key = this.getKey(oauthConfigBaseInfo);
        IccTokenResponse.IccToken token = this.tokenMap.get(key);
        Long currentTime = System.currentTimeMillis();
        if (token != null && token.getTtl() < currentTime) {
            logger.warn("[{}]\u7684token\u5df2\u8fc7\u671f\uff0c\u6e05\u7406token\u4fe1\u606f\uff1a{}", new Object[]{key, JSONUtil.toJsonStr((Object)token)});
            this.clearExpiredToken(oauthConfigBaseInfo);
            return null;
        }
        return this.tokenMap.get(key);
    }

    public IccTokenResponse.IccToken refreshToken(String key, String refreshToken) {
        OauthConfigBaseInfo oauthConfigBaseInfo = this.httpConfigMap.get(key);
        try {
            if (oauthConfigBaseInfo.getGrantType() == GrantType.password) {
                OauthRefreshTokenResponse refreshTokenResponse = OauthProcessor.getIntance().refreshToken(oauthConfigBaseInfo, refreshToken);
                if (refreshTokenResponse.isSuccess()) {
                    OauthRefreshTokenResponse.IccReFreshToken freshToken = refreshTokenResponse.getData();
                    IccTokenResponse.IccToken iccToken = new IccTokenResponse.IccToken();
                    iccToken.setTtl(System.currentTimeMillis() + freshToken.getExpires_in() * 1000L);
                    iccToken.setAccess_token(freshToken.getAccess_token());
                    iccToken.setExpires_in(freshToken.getExpires_in());
                    iccToken.setMagicId(freshToken.getMagicId());
                    iccToken.setUserId(freshToken.getUserId());
                    iccToken.setToken_type(freshToken.getToken_type());
                    iccToken.setRefresh_token(freshToken.getRefresh_token());
                    iccToken.setScope(freshToken.getScope());
                    this.tokenMap.put(this.getKey(oauthConfigBaseInfo), iccToken);
                    return iccToken;
                }
                return this.oauth(oauthConfigBaseInfo);
            }
            if (oauthConfigBaseInfo.getGrantType() == GrantType.client_credentials) {
                IccTokenResponse.IccToken refreshTokenResponse = OauthProcessor.getIntance().oauth(oauthConfigBaseInfo);
                this.tokenMap.put(this.getKey(oauthConfigBaseInfo), refreshTokenResponse);
                return refreshTokenResponse;
            }
        }
        catch (ClientException e) {
            logger.error("fresh token error , grantType=[{}],freshToken=[{}]", new Object[]{oauthConfigBaseInfo.getGrantType().name(), refreshToken});
        }
        return null;
    }

    private void refreshTokenAndKeepAlive() {
        for (Map.Entry<String, IccTokenResponse.IccToken> entry : this.tokenMap.entrySet()) {
            IccTokenResponse.IccToken token = entry.getValue();
            Long currentTime = System.currentTimeMillis();
            if (token.getTtl() - currentTime <= 120000L) {
                this.refreshToken(entry.getKey(), token.getRefresh_token());
            }
            this.keepalive(entry.getKey());
        }
    }

    private void keepalive(String key) {
        OauthConfigBaseInfo oauthConfigBaseInfo = this.httpConfigMap.get(key);
        IccTokenResponse.IccToken token = this.tokenMap.get(key);
        try {
            BrmKeepAliveResponse brmKeepAliveResponse = OauthProcessor.getIntance().keepAlive(oauthConfigBaseInfo, token.getMagicId(), OauthConstant.ClientType.WEB);
            if (!brmKeepAliveResponse.isSuccess() && "27001007".equalsIgnoreCase(brmKeepAliveResponse.getCode())) {
                this.oauth(oauthConfigBaseInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.oauth(oauthConfigBaseInfo);
            }
            catch (Exception retryE) {
                logger.error("keepalive retry error,key:" + key, new Object[]{e});
            }
        }
    }

    private String enGrantKeyName(String grantType) {
        return grantType + ":" + IccProfile.host;
    }

    private GrantType deGrantType(String grantKeyName) {
        return GrantType.valueOf(grantKeyName.substring(0, grantKeyName.indexOf(":")));
    }

    public void clearExpiredToken(OauthConfigBaseInfo oauthConfigBaseInfo) {
        this.tokenMap.remove(this.getKey(oauthConfigBaseInfo));
        this.httpConfigMap.remove(this.getKey(oauthConfigBaseInfo));
    }

    private String getKey(OauthConfigBaseInfo oauthConfigBaseInfo) {
        String host = oauthConfigBaseInfo.getHttpConfigInfo().getHost();
        String port = oauthConfigBaseInfo.getHttpConfigInfo().isEnableHttpTest() ? oauthConfigBaseInfo.getHttpConfigInfo().getHttpPort() : oauthConfigBaseInfo.getHttpConfigInfo().getHttpsPort();
        String grantType = oauthConfigBaseInfo.getGrantType().name();
        String userName = null;
        if (oauthConfigBaseInfo.getGrantType() == GrantType.password) {
            OauthConfigUserPwdInfo oauthConfigUserPwdInfo = (OauthConfigUserPwdInfo)oauthConfigBaseInfo;
            userName = oauthConfigUserPwdInfo.getUsername();
        } else {
            OauthConfigClientInfo oauthConfigClientInfo = (OauthConfigClientInfo)oauthConfigBaseInfo;
            userName = oauthConfigClientInfo.getClientOauthuserId();
        }
        return host + "_" + port + "_" + grantType + "_" + userName + "_" + oauthConfigBaseInfo.getClientId();
    }

    private static class SingletonHolder {
        private static final TokenHandlerProcessor INSTANCE = new TokenHandlerProcessor();

        private SingletonHolder() {
        }
    }
}

