/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.visitor;

import android.support.annotation.NonNull;
import com.dada.smart.user.visitor.ViewVisitor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class VisitorExecutor {
    private static ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardOldestPolicy());
    private static VisitorExecutor visitorExecutor = new VisitorExecutor();
    private TaskInfo taskInfo;

    public static VisitorExecutor getInstance() {
        return visitorExecutor;
    }

    public void execute(ViewVisitor viewVisitor, @NonNull Task task) {
        TaskInfo newTaskInfo = new TaskInfo(viewVisitor, task);
        this.cancelTaskIfNeed(newTaskInfo);
        poolExecutor.execute(newTaskInfo);
    }

    private void cancelTaskIfNeed(TaskInfo newTaskInfo) {
        if (this.taskInfo != null && this.taskInfo.viewVisitor.createTime <= newTaskInfo.viewVisitor.createTime) {
            this.taskInfo.isCancelled = true;
        }
        this.taskInfo = newTaskInfo;
    }

    public class TaskInfo
    implements Runnable {
        ViewVisitor viewVisitor;
        boolean isCancelled;
        Task task;

        public TaskInfo(@NonNull ViewVisitor viewVisitor, Task task) {
            this.viewVisitor = viewVisitor;
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run(this);
        }
    }

    public static interface Task {
        public void run(TaskInfo var1);
    }
}

