/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.visitor;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.ListView;
import com.dada.smart.common.ReflectUtils;
import com.dada.smart.common.ResourceIds;
import com.dada.smart.common.Utils;
import com.dada.smart.common.WindowMagician;
import com.dada.smart.user.R;
import com.dada.smart.user.event.Event;
import com.dada.smart.user.event.Events;
import com.dada.smart.user.event.ViewEvent;
import com.dada.smart.user.event.ViewEventListener;
import com.dada.smart.user.event.ViewTreeChild;
import com.dada.smart.user.visitor.AccessibilityDelegate;
import com.dada.smart.user.visitor.ViewMatcher;
import com.dada.smart.user.visitor.VisitorExecutor;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.List;

public class ViewVisitor
implements ViewEventListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnWindowFocusChangeListener,
ViewTreeObserver.OnWindowAttachListener {
    private ViewEventListener listener;
    private VisitorExecutor executor;
    private Events viewEvents;
    private View decorView;
    private ListView recentListView;
    private RecyclerView recentRecyclerView;
    private WindowManager windowManager;
    private Activity activity;
    private List<ViewTreeObserver> treeObservers;
    private ViewMatcher viewMatcher;
    private State state;
    long createTime;

    public ViewVisitor(@NonNull Activity activity, @NonNull ResourceIds resourceIds, @NonNull Events viewEvents, @NonNull ViewEventListener listener) {
        this.activity = activity;
        this.viewEvents = viewEvents;
        this.listener = listener;
        this.treeObservers = new ArrayList<ViewTreeObserver>();
        this.windowManager = activity.getWindowManager();
        this.decorView = activity.getWindow().getDecorView();
        this.executor = VisitorExecutor.getInstance();
        this.viewMatcher = new ViewMatcher(resourceIds);
        this.state = State.INIT;
        this.createTime = System.currentTimeMillis();
    }

    public void onCreate() {
        this.createViewTreeObservers(this.decorView.findViewById(0x1020002));
        this.state = State.CREATE;
    }

    public void onDestroy() {
        this.state = State.DESTROY;
        this.removeViewTreeObservers();
        this.activity = null;
        this.windowManager = null;
        this.decorView = null;
    }

    @Override
    public void onEvent(ViewEvent event) {
        if (this.listener != null) {
            this.listener.onEvent(event);
        }
    }

    public void onGlobalLayout() {
        Logger.e((String)("onGlobalLayout-" + this.activity), (Object[])new Object[0]);
        this.bindEventAsync();
    }

    public void onWindowAttached() {
    }

    public void onWindowDetached() {
        this.reAddObserverForNewWindow(true);
        Logger.e((String)("onWindowDetached-" + this.activity), (Object[])new Object[0]);
        this.bindEventAsync();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        if (!hasFocus) {
            this.reAddObserverForNewWindow(false);
            Logger.e((String)("onWindowFocusChanged-" + this.activity), (Object[])new Object[0]);
            this.bindEventAsync();
        }
    }

    private void reAddObserverForNewWindow(boolean fromDetached) {
        if (this.treeObservers.size() == 0) {
            return;
        }
        if (this.state == State.DESTROY) {
            return;
        }
        List rootViews = WindowMagician.getFocusWindowRootView((WindowManager)this.activity.getWindowManager(), (boolean)fromDetached);
        for (WindowMagician.ViewRootData viewRootData : rootViews) {
            ViewTreeObserver viewTreeObserver = viewRootData.getView().getViewTreeObserver();
            if (this.treeObservers.contains(viewTreeObserver)) continue;
            viewTreeObserver.addOnWindowAttachListener((ViewTreeObserver.OnWindowAttachListener)this);
            viewTreeObserver.addOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            this.treeObservers.add(viewTreeObserver);
        }
    }

    private void bindEventAsync() {
        this.executor.execute(this, new VisitorExecutor.Task(){

            @Override
            public void run(VisitorExecutor.TaskInfo taskInfo) {
                Utils.sleep((long)300L);
                if (ViewVisitor.this.state != State.DESTROY) {
                    ViewVisitor.this.refreshViewTree(ViewVisitor.this.viewEvents);
                    ViewVisitor.this.bindEventsReal(taskInfo);
                }
            }
        });
    }

    void refreshViewTree(Events events) {
        List<Event> copyEvents = events.getEvents();
        for (Event event : copyEvents) {
            if (event.isIdMatcher()) continue;
            for (ViewTreeChild child : event.getViewTreeChildren()) {
                child.setPassVerify(false);
            }
        }
    }

    private void bindEventAsync(final View root) {
        this.executor.execute(this, new VisitorExecutor.Task(){

            @Override
            public void run(VisitorExecutor.TaskInfo taskInfo) {
                if (ViewVisitor.this.state != State.DESTROY) {
                    ViewVisitor.this.refreshViewTree(ViewVisitor.this.viewEvents);
                    ViewVisitor.this.bindEventToTargetView(root, taskInfo);
                }
            }
        });
    }

    private void bindEventsReal(VisitorExecutor.TaskInfo taskInfo) {
        try {
            if (this.viewEvents.isInMainWindow()) {
                this.decorView.setTag(R.id.tag_tree_index, (Object)0);
                this.bindEventToTargetView(this.decorView, taskInfo);
            } else {
                List dataList = WindowMagician.getFocusWindowRootView((WindowManager)this.windowManager, (boolean)false);
                for (WindowMagician.ViewRootData viewRootData : dataList) {
                    View decorView = viewRootData.getView();
                    decorView.setTag(R.id.tag_tree_index, (Object)0);
                    this.bindEventToTargetView(decorView, taskInfo);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void bindEventToTargetView(View root, VisitorExecutor.TaskInfo taskInfo) {
        if (root == null || root.getVisibility() != 0 || this.state == State.DESTROY || taskInfo.isCancelled) {
            return;
        }
        for (Event event : this.viewEvents.getEvents()) {
            ViewEvent viewEvent = this.viewMatcher.matches(root, event, this.recentListView, this.recentRecyclerView);
            if (viewEvent == null) continue;
            Logger.v((String)("find view=" + root + " event" + event), (Object[])new Object[0]);
            if (event.getTypeId() == 1L) {
                this.addEventToAccessibilityDelegate(root, viewEvent);
                continue;
            }
            if (event.getTypeId() != 4L) continue;
            this.onEvent(viewEvent);
        }
        if (root instanceof ViewGroup) {
            if (root instanceof ListView) {
                this.recentListView = (ListView)root;
                this.setOnScrollListenerIfNeed(this.recentListView);
            } else if (root instanceof RecyclerView) {
                this.recentRecyclerView = (RecyclerView)root;
                this.addOnScrollListenerIfNeed(this.recentRecyclerView);
            }
            ViewGroup parent = (ViewGroup)root;
            try {
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    if (taskInfo.isCancelled) continue;
                    View child = parent.getChildAt(i);
                    child.setTag(R.id.tag_tree_index, (Object)((Integer)parent.getTag(R.id.tag_tree_index) + 1));
                    this.bindEventToTargetView(child, taskInfo);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (root instanceof ListView) {
                this.recentListView = null;
            } else if (root instanceof RecyclerView) {
                this.recentRecyclerView = null;
            }
        }
    }

    private void setOnScrollListenerIfNeed(@NonNull ListView listView) {
        try {
            AbsListView.OnScrollListener originListener = (AbsListView.OnScrollListener)ReflectUtils.reflect((Object)listView).field("mOnScrollListener").get();
            if (!(originListener instanceof ScrollListenerDelegate)) {
                this.recentListView.setOnScrollListener((AbsListView.OnScrollListener)new ScrollListenerDelegate(originListener));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void addOnScrollListenerIfNeed(@NonNull RecyclerView recyclerView) {
        if (recyclerView.getTag(R.id.tag_listener_recycler) == null) {
            RecyclerView.OnScrollListener listener = new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                    if (newState == 0) {
                        Logger.v((String)"RecyclerView.OnScrollListener SCROLL_STATE_IDLE", (Object[])new Object[0]);
                        ViewVisitor.this.bindEventAsync((View)recyclerView);
                    }
                }
            };
            recyclerView.addOnScrollListener(listener);
            recyclerView.setTag(R.id.tag_listener_recycler, (Object)listener);
        }
    }

    private void createViewTreeObservers(View root) {
        ViewTreeObserver viewTreeObserver = root.getViewTreeObserver();
        viewTreeObserver.addOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this);
        viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.treeObservers.add(viewTreeObserver);
    }

    private void removeViewTreeObservers() {
        for (ViewTreeObserver observer : this.treeObservers) {
            if (observer == null || !observer.isAlive()) continue;
            observer.removeOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this);
            observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            observer.removeOnWindowAttachListener((ViewTreeObserver.OnWindowAttachListener)this);
        }
        this.treeObservers.clear();
    }

    private void addEventToAccessibilityDelegate(View root, ViewEvent event) {
        AccessibilityDelegate delegate = (AccessibilityDelegate)((Object)root.getTag(R.id.tag_accessibility));
        if (delegate == null) {
            delegate = new AccessibilityDelegate(this);
            root.setAccessibilityDelegate((View.AccessibilityDelegate)delegate);
            root.setTag(R.id.tag_accessibility, (Object)delegate);
        }
        delegate.addViewEvent(event);
    }

    public class ScrollListenerDelegate
    implements AbsListView.OnScrollListener {
        private AbsListView.OnScrollListener delegate;

        public ScrollListenerDelegate(AbsListView.OnScrollListener delegate) {
            this.delegate = delegate;
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (this.delegate != null) {
                this.delegate.onScrollStateChanged(view, scrollState);
            }
            if (scrollState == 0) {
                ViewVisitor.this.bindEventAsync((View)view);
                Logger.v((String)"AbsListView.OnScrollListener SCROLL_STATE_IDLE", (Object[])new Object[0]);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (this.delegate != null) {
                this.delegate.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
    }

    public static enum State {
        INIT,
        CREATE,
        DESTROY;

    }
}

