package com.dada.smart.user.visitor;

import android.support.annotation.NonNull;
import android.view.View;

import com.dada.smart.user.event.ViewEvent;
import com.dada.smart.user.event.ViewEventListener;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * 辅助功能事件代理监听
 */
public class AccessibilityDelegate extends View.AccessibilityDelegate {

    private List<ViewEvent> viewEvents;
    private ViewEventListener listener;

    public AccessibilityDelegate(@NonNull ViewEventListener listener) {
        this.listener = listener;
        this.viewEvents = new CopyOnWriteArrayList<>();
    }

    public void addViewEvent(ViewEvent newEvent) {
        for (ViewEvent oldEvent : viewEvents) {
            if (oldEvent.isTheSame(newEvent)){
                viewEvents.remove(oldEvent);
            }
        }
        viewEvents.add(newEvent);
    }

    @Override
    public void sendAccessibilityEvent(final View host, int eventType) {
        for (ViewEvent event : viewEvents) {
            if (eventType == event.getEventType()) {
                listener.onEvent(event);
            }
        }
    }

}
