package com.dada.smart.user.event;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.TextView;

import com.dada.smart.common.expression.Extra;

/**
 * 扩展事件
 */
public class ViewEvent implements Extra {

    private View view;
    private Event event;

    public ViewEvent(@NonNull Event event, @Nullable View view) {
        this.event = event;
        this.view = view;
    }

    public int getEventType() {
        if (event != null) {
            if (event.getTypeId() == Event.TYPE_CLICK)
                return AccessibilityEvent.TYPE_VIEW_CLICKED;
        }
        return -1;
    }

    public long getEventId() {
        return event != null ? event.getId() : -1;
    }

    public Event getEvent() {
        return event;
    }

    public boolean isTheSame(ViewEvent otherEvent) {
        return getEventId() == otherEvent.getEventId();
    }

    @Override
    public int getPosition(int key) {
        Integer pos = null;
        if (view != null)
            pos = (Integer) view.getTag(key);
        return pos != null ? pos : -1;
    }

    @Override
    public String getText() {
        if (view instanceof TextView)
            return ((TextView) view).getText().toString();
        return "";
    }

}
