package com.dada.smart.user.event;

import android.text.TextUtils;
import android.util.SparseBooleanArray;

import com.dada.smart.common.expression.Expressions;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import static com.dada.smart.common.EventConfig.HAVE_ID_EVENT_SEP;
import static com.dada.smart.common.EventConfig.IN_MAIN_WINDOW;
import static com.dada.smart.common.EventConfig.NO_ID;
import static com.dada.smart.common.EventConfig.NO_ID_EVENT_SEP;
import static com.dada.smart.common.EventConfig.TYPE_CONTENT_SEP;
import static com.dada.smart.common.EventConfig.VIEW_TREE_SEP;

/**
 * Created by tomkeyzhang on 17/5/18.
 */
public class Event {
    public static final long TYPE_CLICK = 1;
    public static final long TYPE_PV_START = 2;
    public static final long TYPE_PV_END = 3;
    public static final long TYPE_VIEW_SHOW = 4;
    public static final long TYPE_APP_START = -1;
    private long id;
    private long typeId;
    private String viewIdName;
    private String viewClassName;

    private List<ViewTreeChild> viewTreeChildren = new ArrayList<>();

    private boolean inMainWindow = true;

    private String expressions;

    private SparseBooleanArray positions;


    public static Event fromJson(JSONObject object) throws JSONException {
        Event event = new Event();
        event.id = object.getLong("id");
        event.typeId = object.getLong("typeId");
        event.expressions = object.optString("expressions");
        event.parsePosition();

        String widgetIdentifier = object.getString("widgetIdentifier");
        event.parseWidgetIdentifier(widgetIdentifier);
        return event;
    }

    private void parsePosition() {
        if (!TextUtils.isEmpty(expressions)) {
            positions = Expressions.findPosition(expressions);
        }
    }

    public boolean hasPos(int posKey) {
        return positions != null && positions.get(posKey);
    }

    private void parseWidgetIdentifier(String widgetIdentifier) {
        //是否是没有id的
        boolean noId = false;
        if (widgetIdentifier.contains(TYPE_CONTENT_SEP)) {
            String[] ss = widgetIdentifier.split(TYPE_CONTENT_SEP);
            if (ss.length >= 2) {
                String pre = ss[0];
                if (pre.contains(VIEW_TREE_SEP)) {
                    String[] typeContent = pre.split(VIEW_TREE_SEP);
                    if (typeContent.length >= 2) {
                        inMainWindow = TextUtils.equals(typeContent[0], IN_MAIN_WINDOW);
                        noId = TextUtils.equals(typeContent[1], NO_ID);
                    }
                }
                widgetIdentifier = ss[1];
            }
        }

        //无Id
        if (noId || widgetIdentifier.contains(NO_ID_EVENT_SEP)) {
            String[] viewTrees = widgetIdentifier.split(NO_ID_EVENT_SEP);
            if (viewTrees.length > 0) {
                for (String viewTree : viewTrees) {
                    String[] viewTressDesc = viewTree.split(VIEW_TREE_SEP);
                    if (viewTressDesc.length == 3) {
                        ViewTreeChild child = new ViewTreeChild();
                        child.className = viewTressDesc[0];
                        try {
                            child.brothersCount = Integer.parseInt(viewTressDesc[1]);
                            child.index = Integer.parseInt(viewTressDesc[2]);
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        viewTreeChildren.add(child);
                    }
                }
            }
        } else {
            String[] array = widgetIdentifier.split(HAVE_ID_EVENT_SEP);
            if (array.length >= 2) {
                viewClassName = array[0];
                viewIdName = array[1];
            }
        }
    }


    public boolean isInMainWindow() {
        return inMainWindow;
    }

    public long getId() {
        return id;
    }

    public long getTypeId() {
        return typeId;
    }

    public String getViewIdName() {
        return viewIdName;
    }

    public String getViewClassName() {
        return viewClassName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTypeId(long typeId) {
        this.typeId = typeId;
    }

    public void setViewIdName(String viewIdName) {
        this.viewIdName = viewIdName;
    }

    public void setViewClassName(String viewClassName) {
        this.viewClassName = viewClassName;
    }

    public String getExpressions() {
        return expressions;
    }


    public List<ViewTreeChild> getViewTreeChildren() {
        return viewTreeChildren;
    }

    /**
     * 是否采用id的方式来进行view的查找
     */
    public boolean isIdMatcher() {
        return viewTreeChildren.isEmpty();
    }

    public boolean isActivityEvent() {
        return Event.TYPE_PV_START == typeId || Event.TYPE_PV_END == typeId;
    }

    public boolean isViewEvent() {
        return Event.TYPE_CLICK == typeId || Event.TYPE_VIEW_SHOW == typeId;
    }

    @Override
    public String toString() {
        return "id:" + id + " typeId:" + typeId + " viewIdPath:" + viewIdName + " viewClassName:" + viewClassName + " expressions:" + expressions;
    }

    /**
     * 检查一下是不是所有的ViewTree视图链埋点都通过了监测
     */
    public boolean checkAllTreeViewVerified() {
        if (viewTreeChildren.isEmpty()) {
            return false;
        } else {
            for (ViewTreeChild child : viewTreeChildren) {
                if (!child.isPassVerify()) {
                    return false;
                }
            }
        }
        return true;
    }

}
