/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.view.ViewTreeObserver;
import com.dada.smart.common.ActivityMonitor;
import com.dada.smart.common.SmartExpression;
import com.dada.smart.common.Utils;
import com.dada.smart.user.EventLogRepository;
import com.dada.smart.user.ViewVisitor;
import com.dada.smart.user.config.Event;
import com.dada.smart.user.http.CacheHttpClient;
import com.dada.smart.user.http.Client;
import com.dada.smart.user.log.LogDatabase;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewMonitor
extends ActivityMonitor {
    private ViewVisitor viewVisitor;
    private EventLogRepository eventLogRepository;
    private ViewVisitor.OnEventListener listener;
    private long appId;
    private SharedPreferences preferences;
    private ViewTreeObserver viewTreeObserver;
    private ViewTreeObserver.OnWindowFocusChangeListener onWindowFocusChangeListener = new ViewTreeObserver.OnWindowFocusChangeListener(){

        public void onWindowFocusChanged(boolean hasFocus) {
            if (ViewMonitor.this.viewVisitor != null) {
                ViewMonitor.this.viewVisitor.bindEvents();
            }
        }
    };

    public ViewMonitor(Context context, long appId, String server, Client client, EventLogRepository.RequestParam requestParam, boolean debug) {
        super(context, debug);
        this.appId = appId;
        this.preferences = context.getSharedPreferences("app_start.pref", 0);
        this.eventLogRepository = new EventLogRepository.Builder(server).logDao(LogDatabase.getDatabase(context).logDao()).client(client).requestParam(requestParam).build();
        this.listener = new EventListener();
    }

    public ViewMonitor(Context context, long appId, String server, EventLogRepository.RequestParam requestParam, boolean debug) {
        this(context, appId, server, new CacheHttpClient(context.getSharedPreferences("manager.pref", 0)), requestParam, debug);
    }

    public void update() {
        this.eventLogRepository.fetchConfig(this.appId);
        this.eventLogRepository.sendAppStartEventIfNeed(this.preferences, System.currentTimeMillis(), this.appId);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        super.onActivityCreated(activity, savedInstanceState);
        this.triggerPvEvent(Utils.canonicalName((Object)activity), this.getLastPageClass());
        View view = activity.findViewById(0x1020002);
        this.viewVisitor = new ViewVisitor(this.getResourceIds(), activity, this.eventLogRepository, this.listener);
        this.viewTreeObserver = view.getViewTreeObserver();
        this.viewTreeObserver.addOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
    }

    public void onActivityDestroyed(Activity activity) {
        super.onActivityDestroyed(activity);
        if (this.viewTreeObserver != null) {
            this.viewTreeObserver.removeOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
        }
    }

    public void onActivityStopped(Activity activity) {
        super.onActivityStopped(activity);
        if (this.eventLogRepository.hasEvent(Utils.canonicalName((Object)activity))) {
            this.sendEvents();
        }
    }

    private void sendEvents() {
        this.eventLogRepository.sendEvents(this.appId);
    }

    private void triggerPvEvent(String activityName, String refPageName) {
        List<Event> events = this.eventLogRepository.getPvEvents(activityName);
        if (!Utils.isEmpty(events)) {
            for (Event event : events) {
                this.onEvent(event, refPageName);
            }
        }
    }

    public void onEvent(Event event, String refPageName) {
        List results = SmartExpression.fetchResult((Object)this.uiThreadObject().get(), (String)event.getExpressions());
        JSONObject object = new JSONObject();
        for (SmartExpression.Result result : results) {
            if (result.isTypeEqual()) {
                if (result.isLeftEqualsValue()) continue;
                return;
            }
            if (!"assign".equals(result.getType())) continue;
            try {
                object.put(result.getLeft(), (Object)result.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.eventLogRepository.onEvent(event.getId(), event.getTypeId(), refPageName, object.toString());
    }

    @VisibleForTesting
    public void setListener(ViewVisitor.OnEventListener listener) {
        this.listener = listener;
    }

    @VisibleForTesting
    public void setPreferences(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    private class EventListener
    implements ViewVisitor.OnEventListener {
        private EventListener() {
        }

        @Override
        public void onEvent(Event event) {
            ViewMonitor.this.onEvent(event, ViewMonitor.this.getLastPageClass());
        }
    }
}

