/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.visitor;

import android.support.annotation.NonNull;
import android.view.View;
import com.dada.smart.user.event.ViewEvent;
import com.dada.smart.user.event.ViewEventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AccessibilityDelegate
extends View.AccessibilityDelegate {
    private List<ViewEvent> viewEvents;
    private ViewEventListener listener;

    public AccessibilityDelegate(@NonNull ViewEventListener listener) {
        this.listener = listener;
        this.viewEvents = new CopyOnWriteArrayList<ViewEvent>();
    }

    public void addViewEvent(ViewEvent newEvent) {
        for (ViewEvent oldEvent : this.viewEvents) {
            if (!oldEvent.isTheSame(newEvent)) continue;
            this.viewEvents.remove(oldEvent);
        }
        this.viewEvents.add(newEvent);
    }

    public void sendAccessibilityEvent(View host, int eventType) {
        for (ViewEvent event : this.viewEvents) {
            if (eventType != event.getEventType()) continue;
            this.listener.onEvent(event);
        }
    }
}

