package com.dada.smart.user.http;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;

import com.orhanobut.logger.Logger;

import org.json.JSONObject;

import java.util.Map;

/**
 * Created by tomkeyzhang on 14/5/18.
 * 一个缓存get请求的http客户端
 */
public class CacheHttpClient implements Client {
    private SharedPreferences sp;

    public CacheHttpClient(@NonNull SharedPreferences sp) {
        this.sp = sp;
    }

    @Override
    public Call makeCall(final Method method, final String url, final Map<String, ?> param) {
        return new Call() {
            @Override
            public String execute() {
                String result = "";
                try{
                    switch (method) {
                        case GET:
                            Logger.v(method+" request:"+url + ":" + param);
                            result = get(url, param);
                            break;
                        case POST:
                            JSONObject body = new JSONObject(param);
                            Logger.v(method+" request:"+url + ":" + body);
                            result = HttpRequest.post(url).contentType("application/json").send(body.toString()).body();
                            break;
                        default:
                            break;
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
                Logger.v(method+" response:"+url+""+result);
                return result;
            }

            @Override
            public String cache() {
                return sp.getString(cacheKey(url, param), "");
            }
        };
    }

    private String cacheKey(String url, Map<String, ?> param) {
        return url + new JSONObject(param).toString();
    }

    private String get(String url, Map<String, ?> param) {
        String result = "";
        String cacheKey = cacheKey(url, param);
        try {
            result = HttpRequest.get(url, param, false).connectTimeout(3000).readTimeout(5000).body();
            sp.edit().putString(cacheKey, result).commit();
        } catch (HttpRequest.HttpRequestException e) {
            e.printStackTrace();
        }
        return result;
    }

}
