package com.dada.smart.user.config;

import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import static com.dada.smart.common.EventConfig.HAVE_ID_EVENT_SEP;
import static com.dada.smart.common.EventConfig.IN_MAIN_WINDOW;
import static com.dada.smart.common.EventConfig.NO_ID;
import static com.dada.smart.common.EventConfig.NO_ID_EVENT_SEP;
import static com.dada.smart.common.EventConfig.TYPE_CONTENT_SEP;
import static com.dada.smart.common.EventConfig.VIEW_TREE_SEP;

/**
 * Created by tomkeyzhang on 17/5/18.
 */
public class Event {
    public static final long TYPE_CLICK = 1;
    public static final long TYPE_PV = 2;
    public static final long TYPE_APP_START = -1;
    private long id;
    //    private String eventName;
    private long typeId;
    private String viewIdName;
    private String viewClassName;

    private List<ViewTreeChild> viewTreeChildren = new ArrayList<>();

    private boolean inMainWindow = true;

    private String expressions;

    public static Event fromJson(JSONObject object) throws JSONException {
        Event event = new Event();
        event.id = object.getLong("id");
        event.typeId = object.getLong("typeId");
        event.expressions = object.optString("expressions");

        String widgetIdentifier = object.getString("widgetIdentifier");
        parseWidgetIdentifier(event, widgetIdentifier);
        return event;
    }

    private static void parseWidgetIdentifier(Event event, String widgetIdentifier) {
        //是否是没有id的
        boolean noId = false;
        if (widgetIdentifier.contains(TYPE_CONTENT_SEP)) {
            String[] ss = widgetIdentifier.split(TYPE_CONTENT_SEP);
            if (ss.length >= 2) {
                String pre = ss[0];
                if (pre.contains(VIEW_TREE_SEP)) {
                    String[] typeContent = pre.split(VIEW_TREE_SEP);
                    if (typeContent.length >= 2) {
                        event.inMainWindow = TextUtils.equals(typeContent[0], IN_MAIN_WINDOW);
                        noId = TextUtils.equals(typeContent[1], NO_ID);
                    }
                }
                widgetIdentifier = ss[1];
            }
        }

        //无Id
        if (noId || widgetIdentifier.contains(NO_ID_EVENT_SEP)) {
            String[] viewTrees = widgetIdentifier.split(NO_ID_EVENT_SEP);
            if (viewTrees.length > 0) {
                for (String viewTree : viewTrees) {
                    String[] viewTressDesc = viewTree.split(VIEW_TREE_SEP);
                    if (viewTressDesc.length == 3) {
                        ViewTreeChild child = new ViewTreeChild();
                        child.className = viewTressDesc[0];
                        try {
                            child.brothersCount = Integer.parseInt(viewTressDesc[1]);
                            child.index = Integer.parseInt(viewTressDesc[2]);
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        event.viewTreeChildren.add(child);
                    }
                }
            }
        } else {
            String[] array = widgetIdentifier.split(HAVE_ID_EVENT_SEP);
            if (array.length >= 2) {
                event.viewClassName = array[0];
                event.viewIdName = array[1];
            }
        }
    }


    public boolean isInMainWindow() {
        return inMainWindow;
    }

    public void setInMainWindow(boolean inMainWindow) {
        this.inMainWindow = inMainWindow;
    }

    public long getId() {
        return id;
    }

    public long getTypeId() {
        return typeId;
    }

    public String getViewIdName() {
        return viewIdName;
    }

    public String getViewClassName() {
        return viewClassName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTypeId(long typeId) {
        this.typeId = typeId;
    }

    public void setViewIdName(String viewIdName) {
        this.viewIdName = viewIdName;
    }

    public void setViewClassName(String viewClassName) {
        this.viewClassName = viewClassName;
    }

    public String getExpressions() {
        return expressions;
    }

    public void setExpressions(String expressions) {
        this.expressions = expressions;
    }

    public List<ViewTreeChild> getViewTreeChildren() {
        return viewTreeChildren;
    }

    public void setViewTreeChildren(List<ViewTreeChild> viewTreeChildren) {
        this.viewTreeChildren = viewTreeChildren;
    }

    @Override
    public String toString() {
        return "id:" + id + " typeId:" + typeId + " viewIdPath:" + viewIdName + " viewClassName:" + viewClassName + " expressions:" + expressions;
    }


    public static class ViewTreeChild {
        String className;
        //同一层级的兄弟数量
        int brothersCount;
        //在兄弟中排第几
        int index;
        //是否通过验证
        boolean passVerify;

        public String getClassName() {
            return className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public int getBrothersCount() {
            return brothersCount;
        }

        public void setBrothersCount(int brothersCount) {
            this.brothersCount = brothersCount;
        }

        public int getIndex() {
            return index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isPassVerify() {
            return passVerify;
        }

        public void setPassVerify(boolean passVerify) {
            this.passVerify = passVerify;
        }
    }

    /**
     * 检查一下是不是所有的ViewTree视图链埋点都通过了监测
     */
    public boolean checkAllTreeViewVerified() {
        if (viewTreeChildren.isEmpty()) {
            return false;
        } else {
            for (ViewTreeChild child : viewTreeChildren) {
                if (!child.isPassVerify()) {
                    return false;
                }
            }
        }
        return true;
    }

}
