/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.common.expression;

import com.dada.smart.common.ReflectUtils;
import com.dada.smart.common.Utils;
import com.dada.smart.common.expression.Expressions;
import com.dada.smart.common.expression.Extra;
import com.dada.smart.common.expression.Result;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SmartExpression {
    public static final String CONSTRUCTOR_METHOD = "constructor";
    public static final String THIS = "$this";
    public static final String TEXT = "$text";
    private static final Pattern digitPattern = Pattern.compile("^[0-9]*$");
    private String[] expressions;
    private Extra extra;

    public SmartExpression(String expressions, Extra extra) {
        this.expressions = expressions.replaceAll("\n", "").split(";");
        this.extra = extra;
    }

    private Result getResult(Object base, String expression) {
        Result result = new Result(expression);
        if (result.isParseOk()) {
            this.valueGet(base, result);
        }
        return result;
    }

    private void valueGet(Object base, Result result) {
        try {
            Object value = base;
            for (String exp : result.right.split("\\.")) {
                value = exp.contains("(") && exp.contains(")") ? this.methodGet(value, result.getBaseClassName(), exp) : this.propertyGet(value, result.getBaseClassName(), exp);
            }
            result.success = true;
            result.value = value.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            result.success = false;
            result.value = e.getMessage();
        }
    }

    public List<Result> getResult(Object base) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (String expression : this.expressions) {
            if (Utils.isEmpty(expression) || base == null) continue;
            results.add(this.getResult(base, expression));
        }
        return results;
    }

    private Object propertyGet(Object base, String className, String property) {
        int posKey = Expressions.convert(property);
        if (posKey > 0) {
            return this.getPosition(posKey);
        }
        if (TEXT.equals(property)) {
            return this.getText();
        }
        ReflectUtils reflectUtils = !Utils.isEmpty(className) ? ReflectUtils.reflect(className) : ReflectUtils.reflect(base);
        return reflectUtils.field(property).get();
    }

    private Object methodGet(Object base, String className, String method) {
        String[] array = method.split("\\(");
        String methodName = array[0];
        Object[] args = this.convertParam(base, array[1].replaceAll("\\)", ""));
        ReflectUtils reflectUtils = !Utils.isEmpty(className) ? ReflectUtils.reflect(className) : ReflectUtils.reflect(base);
        if (CONSTRUCTOR_METHOD.equals(methodName)) {
            return reflectUtils.newInstance(args).get();
        }
        return reflectUtils.method(methodName, args).get();
    }

    private Object[] convertParam(Object base, String paramsString) {
        if (Utils.isEmpty(paramsString)) {
            return new Object[0];
        }
        String[] params = paramsString.split(",");
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            int posKey = Expressions.convert(param);
            args[i] = posKey > 0 ? this.getPosition(posKey) : (digitPattern.matcher(param).matches() ? Integer.valueOf(Integer.parseInt(param)) : ("this".equals(param) || THIS.equals(param) ? base : param));
        }
        return args;
    }

    private Integer getPosition(int posKey) {
        if (this.extra != null) {
            return this.extra.getPosition(posKey);
        }
        return -1;
    }

    private String getText() {
        if (this.extra != null) {
            return this.extra.getText();
        }
        return "";
    }
}

