/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.common.expression;

import java.util.regex.Pattern;

public class Result {
    private static final Pattern varNamePattern = Pattern.compile("\\p{Lower}\\w*");
    private static final String UNKNOWN = "unknown";
    public static final String TYPE_ASSIGN = "assign";
    public static final String TYPE_EQUAL = "equal";
    private String expression;
    String left = "unknown";
    String right = "unknown";
    String type = "unknown";
    String value;
    private String baseClassName;
    boolean success = false;

    Result(String expression) {
        this.expression = expression;
        try {
            String[] array;
            if (expression.contains("==")) {
                array = expression.split("==");
                this.type = TYPE_EQUAL;
            } else {
                array = expression.split("=");
                this.type = TYPE_ASSIGN;
                if (!varNamePattern.matcher(array[0]).matches()) {
                    this.value = "\u5de6\u4fa7\u53d8\u91cf\u540d\u79f0\u4e0d\u5408\u6cd5";
                    return;
                }
            }
            this.left = array[0];
            this.right = array[1];
            if (this.right.startsWith("<") && this.right.contains(">")) {
                array = this.right.replaceFirst("<", "").split(">");
                this.baseClassName = array[0];
                this.right = array[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isParseOk() {
        return !UNKNOWN.equals(this.left) && !UNKNOWN.equals(this.right) && !UNKNOWN.equals(this.type);
    }

    public String getBaseClassName() {
        String clzz = this.baseClassName;
        this.baseClassName = null;
        return clzz;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isLeftEqualsValue() {
        return this.left != null && this.value != null && TYPE_EQUAL.equals(this.type) && this.left.equals(this.value);
    }

    public boolean isTypeEqual() {
        return TYPE_EQUAL.equals(this.type);
    }

    public boolean isTypeAssign() {
        return TYPE_ASSIGN.equals(this.type);
    }

    public String toString() {
        return this.expression + "," + this.value;
    }
}

