/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.common.expression;

import android.util.SparseBooleanArray;
import com.dada.smart.common.R;
import com.dada.smart.common.Utils;
import com.dada.smart.common.expression.Extra;
import com.dada.smart.common.expression.Result;
import com.dada.smart.common.expression.SmartExpression;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Expressions {
    public static final String POSITION_LINEAR = "$pos";
    public static final String POSITION_LIST = "$lPos";
    public static final String POSITION_RECYCLER = "$rPos";

    public static List<Result> fetchResult(Object base, String expressions, Extra extra) {
        if (Utils.isEmpty(expressions) || base == null) {
            return new ArrayList<Result>();
        }
        return new SmartExpression(expressions, extra).getResult(base);
    }

    public static JSONArray fetchAsArray(Object base, String expressions, Extra extra) {
        List<Result> results = Expressions.fetchResult(base, expressions, extra);
        JSONArray array = new JSONArray();
        for (Result result : results) {
            JSONObject object = new JSONObject();
            try {
                object.put("expression", (Object)result.getExpression());
                object.put("success", result.isSuccess());
                if (result.isTypeEqual()) {
                    object.put("value", (Object)(result.isSuccess() ? String.valueOf(result.getLeft().equals(result.getValue())) : result.getValue()));
                } else if (result.isTypeAssign()) {
                    object.put("value", (Object)result.getValue());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            array.put((Object)object);
        }
        return array;
    }

    public static int convert(String posKey) {
        if (POSITION_LIST.equals(posKey)) {
            return R.id.tag_list_pos_index;
        }
        if (POSITION_RECYCLER.equals(posKey)) {
            return R.id.tag_recycler_pos_index;
        }
        if (POSITION_LINEAR.equals(posKey)) {
            return R.id.tag_pos_index;
        }
        return -1;
    }

    public static SparseBooleanArray findPosition(String expressions) {
        SparseBooleanArray positions = new SparseBooleanArray(2);
        if (expressions.contains(POSITION_LINEAR)) {
            positions.append(R.id.tag_pos_index, true);
        }
        if (expressions.contains(POSITION_LIST)) {
            positions.append(R.id.tag_list_pos_index, true);
        }
        if (expressions.contains(POSITION_RECYCLER)) {
            positions.append(R.id.tag_recycler_pos_index, true);
        }
        return positions;
    }
}

