/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.common;

import com.dada.smart.common.ReflectUtils;
import com.dada.smart.common.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SmartExpression {
    private static final Pattern varNamePattern = Pattern.compile("\\p{Lower}\\w*");
    private static final String UNKNOWN = "unknown";
    public static final String CONSTRUCTOR_METHOD = "constructor";
    public static final String TYPE_ASSIGN = "assign";
    public static final String TYPE_EQUAL = "equal";
    private static final Pattern digitPattern = Pattern.compile("^[0-9]*$");
    private String[] expressions;

    public SmartExpression(String expressions) {
        this.expressions = expressions.replaceAll("\n", "").split(";");
    }

    private Result getResult(Object base, String expression) {
        Result result = new Result(expression);
        if (result.isParseOk()) {
            this.valueGet(base, result);
        }
        return result;
    }

    private void valueGet(Object base, Result result) {
        try {
            Object value = base;
            for (String exp : result.right.split("\\.")) {
                value = exp.contains("(") && exp.contains(")") ? this.methodGet(value, result.getBaseClassName(), exp) : this.propertyGet(value, result.getBaseClassName(), exp);
            }
            result.success = true;
            result.value = value.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            result.success = false;
            result.value = e.getMessage();
        }
    }

    public List<Result> getResult(Object base) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (String expression : this.expressions) {
            if (Utils.isEmpty(expression) || base == null) continue;
            results.add(this.getResult(base, expression));
        }
        return results;
    }

    private Object propertyGet(Object base, String className, String property) {
        ReflectUtils reflectUtils = !Utils.isEmpty(className) ? ReflectUtils.reflect(className) : ReflectUtils.reflect(base);
        return reflectUtils.field(property).get();
    }

    private Object methodGet(Object base, String className, String method) {
        String[] array = method.split("\\(");
        String methodName = array[0];
        Object[] args = this.convertParam(base, array[1].replaceAll("\\)", ""));
        ReflectUtils reflectUtils = !Utils.isEmpty(className) ? ReflectUtils.reflect(className) : ReflectUtils.reflect(base);
        if (CONSTRUCTOR_METHOD.equals(methodName)) {
            return reflectUtils.newInstance(args).get();
        }
        return reflectUtils.method(methodName, args).get();
    }

    private Object[] convertParam(Object base, String paramsString) {
        if (Utils.isEmpty(paramsString)) {
            return new Object[0];
        }
        String[] params = paramsString.split(",");
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            args[i] = digitPattern.matcher(param).matches() ? Integer.valueOf(Integer.parseInt(param)) : ("this".equals(param) ? base : param);
        }
        return args;
    }

    public static List<Result> fetchResult(Object base, String expressions) {
        if (Utils.isEmpty(expressions) || base == null) {
            return new ArrayList<Result>();
        }
        return new SmartExpression(expressions).getResult(base);
    }

    public static JSONArray fetchAsArray(Object base, String expressions) {
        List<Result> results = SmartExpression.fetchResult(base, expressions);
        JSONArray array = new JSONArray();
        for (Result result : results) {
            JSONObject object = new JSONObject();
            try {
                object.put("expression", (Object)result.getExpression());
                object.put("success", result.isSuccess());
                if (result.isTypeEqual()) {
                    object.put("value", (Object)(result.isSuccess() ? String.valueOf(result.getLeft().equals(result.getValue())) : result.getValue()));
                } else if (result.isTypeAssign()) {
                    object.put("value", (Object)result.getValue());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            array.put((Object)object);
        }
        return array;
    }

    public static class Result {
        private String expression;
        private String left = "unknown";
        private String right = "unknown";
        private String type = "unknown";
        private String value;
        private String baseClassName;
        private boolean success = false;

        private Result(String expression) {
            this.expression = expression;
            try {
                String[] array;
                if (expression.contains("==")) {
                    array = expression.split("==");
                    this.type = SmartExpression.TYPE_EQUAL;
                } else {
                    array = expression.split("=");
                    this.type = SmartExpression.TYPE_ASSIGN;
                    if (!varNamePattern.matcher(array[0]).matches()) {
                        this.value = "\u5de6\u4fa7\u53d8\u91cf\u540d\u79f0\u4e0d\u5408\u6cd5";
                        return;
                    }
                }
                this.left = array[0];
                this.right = array[1];
                if (this.right.startsWith("<") && this.right.contains(">")) {
                    array = this.right.replaceFirst("<", "").split(">");
                    this.baseClassName = array[0];
                    this.right = array[1];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean isParseOk() {
            return !SmartExpression.UNKNOWN.equals(this.left) && !SmartExpression.UNKNOWN.equals(this.right) && !SmartExpression.UNKNOWN.equals(this.type);
        }

        public String getBaseClassName() {
            String clzz = this.baseClassName;
            this.baseClassName = null;
            return clzz;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getLeft() {
            return this.left;
        }

        public void setLeft(String left) {
            this.left = left;
        }

        public String getRight() {
            return this.right;
        }

        public void setRight(String right) {
            this.right = right;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getExpression() {
            return this.expression;
        }

        public boolean isLeftEqualsValue() {
            return this.left != null && this.value != null && SmartExpression.TYPE_EQUAL.equals(this.type) && this.left.equals(this.value);
        }

        public boolean isTypeEqual() {
            return SmartExpression.TYPE_EQUAL.equals(this.type);
        }

        public boolean isTypeAssign() {
            return SmartExpression.TYPE_ASSIGN.equals(this.type);
        }

        public String toString() {
            return this.expression + "," + this.value;
        }
    }
}

