package com.dada.response.watcher;

import android.app.Application;
import android.content.Context;

import com.dada.monitor.network.MonitorNetworkUtil;
import com.dada.monitor.network.http.header.VerifyHeaderInterface;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;
import com.dada.response.watcher.watcher.ResponseLoop;

import java.util.List;

import okhttp3.Interceptor;

/**
 * Created by whh on 2019/6/21
 */
public class ResponseWatchUtil {
    private static final String TAG = ResponseWatchUtil.class.getSimpleName();

    private static ResponseWatchUtil instance;

    public volatile static boolean isAlreadyInit;

    public volatile static boolean isAlreadyStart;

    private static Application globalContext;

    /**
     * 获取 ResponseWatchUtil 对象
     */
    public static ResponseWatchUtil getInstance() {
        if (null == instance) {
            instance = new ResponseWatchUtil();
        }
        return instance;
    }

    public ResponseWatchUtil init(Application application) {
        if (isAlreadyInit) {
            ResponseWatchDebug.w(TAG, "already init");
            return getInstance();
        }
        isAlreadyInit = true;
        globalContext = application;
        ResponseLoop.getInstance().init();
        return getInstance();
    }

    /**
     * 设置必要的 Header
     */
    public ResponseWatchUtil setHeaderInterceptor(Interceptor interceptor) {
        ResponseHelper.getInstance().getNetworkUtil().setHeaderInterceptor(interceptor);
        return getInstance();
    }

    /**
     * 设置必要的 Header
     */
    public ResponseWatchUtil setHeaderNeedInterface(VerifyHeaderInterface verifyHeaderInterface) {
        ResponseHelper.getInstance().getNetworkUtil().setSignHeaderInterface(verifyHeaderInterface);
        return getInstance();
    }

    /**
     * 设置要监听的 path
     */
    public ResponseWatchUtil setWatchedPaths(List<String> watchedPaths) {
        ResponseConfig.WATCHED_PATHS = watchedPaths;
        return getInstance();
    }

    /**
     * 开始 Response 监听
     */
    public void startResponseWatch() {
        if (isAlreadyStart) {
            ResponseWatchDebug.w(TAG, "already start");
            return;
        }
        isAlreadyStart = true;
        ResponseWatchDebug.d(TAG, "startResponseWatch");
        ResponseLoop.getInstance().startResponseLoop();
    }

    /**
     * 停止 Response 监听
     */
    public void stopResponseWatch() {
        isAlreadyStart = false;
        ResponseWatchDebug.d(TAG, "stopResponseWatch");
        ResponseLoop.getInstance().stopResponseLoop();
    }

    /**
     * 获得全局 applicationContext
     */
    public static Context getContext() {
        return globalContext;
    }

    /**
     * 设置 debug
     */
    public ResponseWatchUtil setDebug(boolean isDebug) {
        ResponseWatchDebug.setDebug(isDebug);
        return getInstance();
    }

    /**
     * 设置 debug
     */
    public ResponseWatchUtil setDebugTag(String debugTag) {
        ResponseWatchDebug.setDebugTag(debugTag);
        return getInstance();
    }

    /**
     * 设置是否是线上环境
     */
    public ResponseWatchUtil setOnline(boolean isOnline) {
        ResponseHelper.getInstance().getNetworkUtil().setOnline(isOnline);
        return getInstance();
    }

    /**
     * 设置ndev环境的 host
     */
    public ResponseWatchUtil setNdevMetricsHost(String ndevMetricsHost) {
        MonitorNetworkUtil.getInstance().setNdevMetricsHost(ndevMetricsHost);
        return getInstance();
    }

    /**
     * 设置轮询时间，不能为 0
     */
    public ResponseWatchUtil setTravelTime(int travelTime) {
        ResponseConfig.TRAVEL_TIME = travelTime;
        return getInstance();
    }

    public ResponseWatchUtil setNeededTags(TagInterface neededTags) {
        ResponseHelper.getInstance().setTagInterface(neededTags);
        return getInstance();
    }
}
