/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.watcher;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.dada.monitor.network.MonitorNetworkUtil;
import com.dada.monitor.network.http.pojo.DaDaResponseBody;
import com.dada.monitor.network.util.Json;
import com.dada.response.watcher.ResponseWatchUtil;
import com.dada.response.watcher.entity.NetStatus;
import com.dada.response.watcher.entity.NetStatusCache;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.ResponseWatchDebug;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;

public class ResponseHelper {
    public static final String TAG = "ResponseHelper";
    private static final String SPF_RESPONSE_REPOSITORY = "spf_response_repository";
    private static final String SPF_NETSTATUS = "netstatus";
    private static ResponseHelper instance;
    private NetStatusCache netStatus;
    private SharedPreferences netStatusPre;
    private Executor executor = Executors.newSingleThreadExecutor();
    private TagInterface tagInterface;
    private final ReentrantLock lock = new ReentrantLock();
    private static MonitorNetworkUtil networkUtil;

    public static ResponseHelper getInstance() {
        if (instance == null) {
            instance = new ResponseHelper();
        }
        return instance;
    }

    public MonitorNetworkUtil getNetworkUtil() {
        if (null == networkUtil) {
            networkUtil = MonitorNetworkUtil.getInstance();
        }
        return networkUtil;
    }

    private ResponseHelper() {
        this.netStatusPre = ResponseWatchUtil.getContext().getSharedPreferences(SPF_RESPONSE_REPOSITORY, 0);
        String netStatusStr = this.netStatusPre.getString(SPF_NETSTATUS, "");
        if (!TextUtils.isEmpty((CharSequence)netStatusStr)) {
            try {
                this.netStatus = (NetStatusCache)Json.fromJson((String)netStatusStr, NetStatusCache.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == this.netStatus) {
                this.netStatus = new NetStatusCache();
            }
            ResponseWatchDebug.d(TAG, "netStatus  " + this.netStatus.toString());
        } else {
            ResponseWatchDebug.d(TAG, "SharedPreferences new NetStatusCache");
            this.netStatus = new NetStatusCache();
        }
    }

    public synchronized void addWatchedData(String domain, String uri, String status, long tookMs) {
        ResponseWatchDebug.d(TAG, "addWatchedData  domain: " + domain + " uri: " + uri + " status: " + status + " ms: " + tookMs);
        Map<String, NetStatusCache.Fields> statusMap = this.netStatus.statusMap;
        String key = String.format(Locale.CHINA, "%s;%s;%s", domain, uri, status);
        if (statusMap.containsKey(key)) {
            NetStatusCache.Fields fields = statusMap.get(key);
            if (null != fields) {
                long count = fields.getCount();
                long sum = fields.getSum();
                statusMap.put(key, fields.setCount(++count).setSum(sum + tookMs));
                this.syncSharedPreferences();
            }
        } else {
            statusMap.put(key, new NetStatusCache.Fields().setCount(1L).setSum(tookMs));
            this.syncSharedPreferences();
        }
    }

    void saveAndUpload() {
        try {
            this.sendResponseLog();
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d(TAG, "\u53d1\u9001\u5931\u8d25: " + e.getMessage());
        }
    }

    private void sendResponseLog() throws Exception {
        this.lock.lock();
        NetStatus netStatusToUpload = this.unZipNetStatus();
        ResponseWatchDebug.d(TAG, "\u8f6c\u6362\u5b8c\u7c7b\u578b");
        if (null == netStatusToUpload || ArrayUtils.isEmpty(netStatusToUpload.getMetrics())) {
            return;
        }
        NetStatusCache netStatusCopy = (NetStatusCache)this.netStatus.clone();
        ResponseWatchDebug.d(TAG, "\u5907\u4efd\u7684netStatus \uff1a " + netStatusCopy.toString());
        this.lock.unlock();
        ResponseWatchDebug.d(TAG, "\u771f\u6b63\u5f00\u59cb\u53d1\u9001 netStatusToUpload " + netStatusToUpload.toString());
        DaDaResponseBody responseBody = this.getNetworkUtil().postUrlsyn("api/app/metrics/collect", Json.toJson((Object)netStatusToUpload));
        if (null != responseBody && responseBody.isOk()) {
            this.resetNetStatusCache(netStatusCopy);
        } else if (null != responseBody) {
            ResponseWatchDebug.d(TAG, "\u5931\u8d25 code " + responseBody.getErrorCode() + " message" + responseBody.getErrorMsg());
        } else {
            ResponseWatchDebug.d(TAG, "\u7f51\u7edc\u4e0d\u901a");
        }
    }

    public void setTagInterface(TagInterface tagInterface) {
        this.tagInterface = tagInterface;
    }

    private NetStatus unZipNetStatus() {
        Map<String, NetStatusCache.Fields> statusMap = this.netStatus.statusMap;
        if (statusMap.isEmpty()) {
            return null;
        }
        NetStatus.Tag tag = new NetStatus.Tag().setApp(this.tagInterface.getAppName()).setCity(this.tagInterface.getCityCode()).setDeviceId(this.tagInterface.getDeviceId()).setNetwork(this.tagInterface.getNetWork()).setOperator(this.tagInterface.getOperator());
        ArrayList<NetStatus.Metric> metrics = new ArrayList<NetStatus.Metric>();
        for (String key : statusMap.keySet()) {
            String[] keyValue;
            NetStatusCache.Fields field = statusMap.get(key);
            if (null == field || 0L == field.getCount() || (keyValue = key.split(";")).length < 3) continue;
            String domain = keyValue[0];
            String uri = keyValue[1];
            String status = keyValue[2];
            long count = field.getCount();
            long sum = field.getSum();
            NetStatus.Metric.Fields fields = new NetStatus.Metric.Fields().setCount(field.getCount()).setSum(field.getSum());
            fields.setMean((int)((double)sum / (double)count));
            NetStatus.Metric.Tag tags = new NetStatus.Metric.Tag().setDomain(domain).setStatus(status).setUri(uri);
            NetStatus.Metric metric = new NetStatus.Metric().setFields(fields).setTags(tags);
            metrics.add(metric);
        }
        return new NetStatus().setTime(System.currentTimeMillis()).setTags(tag).setMetrics(metrics);
    }

    private synchronized void resetNetStatusCache(NetStatusCache netStatusCopy) {
        if (null == netStatusCopy || netStatusCopy.statusMap.isEmpty()) {
            return;
        }
        ResponseWatchDebug.d(TAG, "\u91cd\u7f6e\uff1a\u5907\u4efd\u7684 netStatusCopy\uff1a " + netStatusCopy.toString());
        ResponseWatchDebug.d(TAG, "\u91cd\u7f6e\uff1a\u5185\u5b58\u4e2d\u7684 netStatus\uff1a " + this.netStatus.toString());
        Map<String, NetStatusCache.Fields> netStatusZipsCopy = netStatusCopy.statusMap;
        Map<String, NetStatusCache.Fields> netStatusZipsCache = this.netStatus.statusMap;
        for (Map.Entry<String, NetStatusCache.Fields> entryCopy : netStatusZipsCopy.entrySet()) {
            for (Map.Entry<String, NetStatusCache.Fields> entry : netStatusZipsCache.entrySet()) {
                String keyCopy = entryCopy.getKey();
                String key = entry.getKey();
                NetStatusCache.Fields fieldsCopy = entryCopy.getValue();
                NetStatusCache.Fields fields = entry.getValue();
                if (null == keyCopy || null == key || null == fieldsCopy || null == fields) {
                    return;
                }
                if (!keyCopy.equals(key)) continue;
                long resetCount = fields.getCount() - fieldsCopy.getCount();
                long resetSum = fields.getSum() - fieldsCopy.getSum();
                entry.setValue(new NetStatusCache.Fields().setCount(resetCount).setSum(resetSum));
            }
        }
        this.syncSharedPreferences();
    }

    private synchronized void syncSharedPreferences() {
        this.executor.execute(() -> {
            try {
                this.netStatusPre.edit().putString(SPF_NETSTATUS, Json.toJson((Object)this.netStatus)).apply();
            }
            catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences save exception: " + e.getMessage());
            }
        });
    }
}

