/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher;

import android.app.Application;
import android.content.Context;
import com.dada.monitor.network.MonitorNetworkUtil;
import com.dada.monitor.network.http.header.VerifyHeaderInterface;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;
import com.dada.response.watcher.watcher.ResponseLoop;
import java.util.List;
import okhttp3.Interceptor;

public class ResponseWatchUtil {
    private static final String TAG = ResponseWatchUtil.class.getSimpleName();
    private static ResponseWatchUtil instance;
    public static volatile boolean isAlreadyInit;
    public static volatile boolean isAlreadyStart;
    private static Application globalContext;

    public static ResponseWatchUtil getInstance() {
        if (null == instance) {
            instance = new ResponseWatchUtil();
        }
        return instance;
    }

    public ResponseWatchUtil init(Application application) {
        if (isAlreadyInit) {
            ResponseWatchDebug.w(TAG, "already init");
            return ResponseWatchUtil.getInstance();
        }
        isAlreadyInit = true;
        globalContext = application;
        ResponseLoop.getInstance().init();
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setHeaderInterceptor(Interceptor interceptor) {
        ResponseHelper.getInstance().getNetworkUtil().setHeaderInterceptor(interceptor);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setHeaderNeedInterface(VerifyHeaderInterface verifyHeaderInterface) {
        ResponseHelper.getInstance().getNetworkUtil().setSignHeaderInterface(verifyHeaderInterface);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setWatchedPaths(List<String> watchedPaths) {
        ResponseConfig.WATCHED_PATHS = watchedPaths;
        return ResponseWatchUtil.getInstance();
    }

    public void startResponseWatch() {
        if (isAlreadyStart) {
            ResponseWatchDebug.w(TAG, "already start");
            return;
        }
        isAlreadyStart = true;
        ResponseWatchDebug.d(TAG, "startResponseWatch");
        ResponseLoop.getInstance().startResponseLoop();
    }

    public void stopResponseWatch() {
        isAlreadyStart = false;
        ResponseWatchDebug.d(TAG, "stopResponseWatch");
        ResponseLoop.getInstance().stopResponseLoop();
    }

    public static Context getContext() {
        return globalContext;
    }

    public ResponseWatchUtil setDebug(boolean isDebug) {
        ResponseWatchDebug.setDebug(isDebug);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setDebugTag(String debugTag) {
        ResponseWatchDebug.setDebugTag(debugTag);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setOnline(boolean isOnline) {
        ResponseHelper.getInstance().getNetworkUtil().setOnline(isOnline);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setNdevMetricsHost(String ndevMetricsHost) {
        MonitorNetworkUtil.getInstance().setNdevMetricsHost(ndevMetricsHost);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setTravelTime(int travelTime) {
        ResponseConfig.TRAVEL_TIME = travelTime;
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setNeededTags(TagInterface neededTags) {
        ResponseHelper.getInstance().setTagInterface(neededTags);
        return ResponseWatchUtil.getInstance();
    }
}

