/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.watcher;

import com.dada.response.watcher.http.api.MetricsClient;
import com.dada.response.watcher.http.convert.FastJsonConverterFactory;
import com.dada.response.watcher.http.log.Retrofit2AndroidLog;
import com.dada.response.watcher.interceptor.HeaderInterceptor;
import com.dada.response.watcher.util.ResponseWatchDebug;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class ResponseApi {
    private static final String METRICS_ONLINE = "https://metrics.imdada.cn/";
    private static final String METRICS_DEV = "http://metrics.ndev.imdada.cn/";
    private static MetricsClient metricsApi;
    private static Interceptor headerInterceptor;
    private static boolean isOnline;

    private static OkHttpClient provideMetricsOkHttpClient() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new Retrofit2AndroidLog("response-api")).setLevel(ResponseWatchDebug.isDebug() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)interceptor);
        if (null != headerInterceptor) {
            builder.addInterceptor(headerInterceptor);
        }
        builder.addInterceptor((Interceptor)HeaderInterceptor.getInstance());
        return builder.build();
    }

    public static void setHeaderInterceptor(Interceptor headerInterceptor) {
        ResponseApi.headerInterceptor = headerInterceptor;
    }

    public static boolean isOnline() {
        return isOnline;
    }

    public static void setOnline(boolean isOnline) {
        ResponseApi.isOnline = isOnline;
    }

    private static String getMetricsHost() {
        if (isOnline) {
            return METRICS_ONLINE;
        }
        return METRICS_DEV;
    }

    static MetricsClient getClientApi() {
        if (null == metricsApi) {
            metricsApi = (MetricsClient)new Retrofit.Builder().baseUrl(ResponseApi.getMetricsHost()).client(ResponseApi.provideMetricsOkHttpClient()).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).build().create(MetricsClient.class);
        }
        return metricsApi;
    }

    static {
        isOnline = false;
    }
}

