/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.interceptor;

import com.dada.response.watcher.inter.VerifyHeaderInterface;
import com.dada.response.watcher.util.MD5;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.util.StringUtil;
import com.dada.response.watcher.watcher.ResponseApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderInterceptor
implements Interceptor {
    private VerifyHeaderInterface headerInterface;
    private static final HeaderInterceptor instance = new HeaderInterceptor();

    public static HeaderInterceptor getInstance() {
        return instance;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request.Builder request = original.newBuilder();
        String timestamp = System.currentTimeMillis() + "";
        request.addHeader("timestamp", timestamp);
        Map<String, String> map = this.headerInterface.getHeader();
        map.put("timestamp", timestamp);
        String key = ResponseApi.isOnline() ? "1FD8B8A46755176E25510B8010FEC5E5" : "dada123456";
        request.addHeader("sign", this.getMD5Sign(map, key));
        return chain.proceed(request.build());
    }

    public void setHeaderNeedInterface(VerifyHeaderInterface headerInterface) {
        this.headerInterface = headerInterface;
    }

    public String getMD5Sign(Map<String, String> params, String key) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        params.remove("sign");
        String link = HeaderInterceptor.buildLink(params, key);
        ResponseWatchDebug.d("HeaderInterceptor", link);
        return MD5.getMD5(link).toUpperCase();
    }

    private static String buildLink(Map<String, String> params, String key) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        ArrayList<Map.Entry<String, String>> paramsList = new ArrayList<Map.Entry<String, String>>(params.entrySet());
        Collections.sort(paramsList, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : paramsList) {
            if (StringUtil.isEmpty((String)entry.getKey()) && StringUtil.isEmpty((String)entry.getValue())) continue;
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        return sb.append("key=").append(key).toString();
    }
}

