/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.http.pojo;

import com.alibaba.fastjson.JSONException;
import com.dada.response.watcher.util.Json;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.util.StringUtil;
import java.util.List;
import org.json.JSONObject;

public class ResponseBody {
    public static final String ERROR_CODE_NO_GPS = "-100";
    private static final String OK = "ok";
    private String status;
    private String content;
    private String errorCode;
    private String errorMsg;
    private Object cache;

    public static ResponseBody failed(String errorMsg) {
        ResponseBody body = new ResponseBody();
        body.status = "fail";
        body.errorMsg = errorMsg;
        return body;
    }

    public static ResponseBody failedCode(String errorCode) {
        ResponseBody body = new ResponseBody();
        body.status = "fail";
        body.errorCode = errorCode;
        return body;
    }

    public static ResponseBody failed(String errorCode, String errorMsg) {
        ResponseBody body = new ResponseBody();
        body.status = "fail";
        body.errorCode = errorCode;
        body.errorMsg = errorMsg;
        return body;
    }

    public static ResponseBody success() {
        ResponseBody body = new ResponseBody();
        body.status = OK;
        return body;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return null == this.errorMsg ? "\u672a\u77e5\u9519\u8bef" : this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isOk() {
        return OK.equals(this.status);
    }

    void showDataFormatError(Exception e) {
        e.printStackTrace();
        ResponseWatchDebug.d("response", "\u6570\u636e\u89e3\u6790\u51fa\u9519\uff01");
    }

    public <T> T getContentAs(Class<T> clzz) {
        try {
            return Json.fromJson(this.content, clzz);
        }
        catch (JSONException e) {
            this.showDataFormatError((Exception)((Object)e));
            return null;
        }
    }

    public JSONObject getContentAsObject() {
        try {
            return new JSONObject(this.content);
        }
        catch (org.json.JSONException e) {
            e.printStackTrace();
            this.showDataFormatError((Exception)((Object)e));
            return new JSONObject();
        }
    }

    public <T> List<T> getContentAsList(Class<T> clzz) {
        try {
            return Json.fromJsons(this.content, clzz);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.showDataFormatError((Exception)((Object)e));
            return null;
        }
    }

    public <T> T getContentChildAs(String key, Class<T> clzz) {
        try {
            return Json.fromJson(new JSONObject(this.content).getString(key), clzz);
        }
        catch (org.json.JSONException e) {
            e.printStackTrace();
            this.showDataFormatError((Exception)((Object)e));
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.showDataFormatError((Exception)((Object)e));
        }
        return null;
    }

    public <T> List<T> getContentChildsAs(String key, Class<T> clzz) {
        try {
            JSONObject object = new JSONObject(this.content);
            String data = object.optString(key);
            if (!StringUtil.isEmpty(data)) {
                return Json.fromJsons(data, clzz);
            }
        }
        catch (org.json.JSONException e) {
            e.printStackTrace();
            this.showDataFormatError((Exception)((Object)e));
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.showDataFormatError((Exception)((Object)e));
        }
        return null;
    }

    public <T> List<T> getContentChildsAs(Class<T> clzz) {
        try {
            return Json.fromJsons(this.content, clzz);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.showDataFormatError((Exception)((Object)e));
            return null;
        }
    }

    public Object getCache() {
        return this.cache;
    }

    public void setCache(Object cache) {
        this.cache = cache;
    }
}

