/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.inter.VerifyHeaderInterface;
import com.dada.response.watcher.interceptor.HeaderInterceptor;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.watcher.ResponseApi;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;
import com.dada.response.watcher.watcher.ResponseWorker;
import java.util.List;
import okhttp3.Interceptor;

public class ResponseWatchUtil {
    private static final String TAG = ResponseWatchUtil.class.getSimpleName();
    private static ResponseWatchUtil instance;
    public static volatile boolean isAlreadyStart;
    private static Application globalContext;

    public static ResponseWatchUtil getInstance() {
        if (null == instance) {
            instance = new ResponseWatchUtil();
        }
        return instance;
    }

    public ResponseWatchUtil initContext(@NonNull Application application) {
        globalContext = application;
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setHeaderInterceptor(Interceptor interceptor) {
        ResponseApi.setHeaderInterceptor(interceptor);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setHeaderNeedInterface(VerifyHeaderInterface needInterface) {
        HeaderInterceptor.getInstance().setHeaderNeedInterface(needInterface);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setWatchedPaths(List<String> watchedPaths) {
        ResponseConfig.WATCHED_PATHS = watchedPaths;
        return ResponseWatchUtil.getInstance();
    }

    public void startResponseWatch() {
        if (isAlreadyStart) {
            ResponseWatchDebug.w(TAG, "already init");
            return;
        }
        isAlreadyStart = true;
        ResponseWatchDebug.d(TAG, "startResponseWatch");
        ResponseWorker.startResponseWatchWorker((Context)globalContext);
    }

    public void stopResponseWatch() {
        isAlreadyStart = false;
        ResponseWatchDebug.d(TAG, "stopResponseWatch");
        ResponseWorker.stopResponseWatchWorker();
    }

    public static Context getContext() {
        return globalContext;
    }

    public ResponseWatchUtil setDebug(boolean isDebug) {
        ResponseWatchDebug.setDebug(isDebug);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setOnline(boolean isOnline) {
        ResponseApi.setOnline(isOnline);
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setTravelTime(int travelTime) {
        ResponseConfig.TRAVEL_TIME = travelTime;
        return ResponseWatchUtil.getInstance();
    }

    public ResponseWatchUtil setNeededTags(TagInterface neededTags) {
        ResponseHelper.getInstance().setTagInterface(neededTags);
        return ResponseWatchUtil.getInstance();
    }
}

