package com.dada.response.watcher.watcher;


import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.alibaba.fastjson.JSON;
import com.dada.response.watcher.ResponseWatchUtil;
import com.dada.response.watcher.entity.NetStatus;
import com.dada.response.watcher.entity.NetStatusCache;
import com.dada.response.watcher.http.pojo.ResponseBody;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.ResponseWatchDebug;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import retrofit2.Response;

/**
 * Created by whh on 2019/5/31
 */
public class ResponseHelper {

    public static final String TAG = "ResponseHelper";
    private static final String SPF_RESPONSE_REPOSITORY = "spf_response_repository";
    private static final String SPF_NETSTATUS = "netstatus";


    private static ResponseHelper instance;
    private NetStatusCache netStatus;
    private SharedPreferences netStatusPre;

    private Executor executor = Executors.newSingleThreadExecutor();
    private TagInterface tagInterface;
    //    private final ReentrantLock lock = new ReentrantLock();
    //lock.lock()  lock.unlock()

    public static ResponseHelper getInstance() {
        if (instance == null) {
            instance = new ResponseHelper();
        }
        return instance;
    }

    private ResponseHelper() {
        netStatusPre = ResponseWatchUtil.getContext().getSharedPreferences(SPF_RESPONSE_REPOSITORY, Context.MODE_PRIVATE);
        String netStatusStr = netStatusPre.getString(SPF_NETSTATUS, "");
        if (!TextUtils.isEmpty(netStatusStr)) {
            //同步数据
            try {
                netStatus = JSON.parseObject(netStatusStr, NetStatusCache.class);
                ResponseWatchDebug.d(TAG, "netStatus  " + netStatus.toString());
            } catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences 1  " + e.getMessage());
                netStatus = new NetStatusCache();
            }
        } else {
            ResponseWatchDebug.d(TAG, "SharedPreferences new NetStatusCache");
            netStatus = new NetStatusCache();
        }
    }

    public synchronized void addWatchedData(String domain, String uri, int status) {
        //使用压缩的数据类型，不能对 netStatus 加锁，因为在上传的时候需要对 netStatus 仍然是可以进行写入的
        final Map<String, Long> statusMap = netStatus.statusMap;
        String key = String.format(Locale.CHINA, "%s;%s;%d", domain, uri, status);

        if (statusMap.containsKey(key)) {
            Long count = statusMap.get(key);
            if (null != count) {
                statusMap.put(key, ++count);
                syncSharedPreferences();
            }
        } else {
            statusMap.put(key, 1L);
            syncSharedPreferences();
        }

        ResponseWatchDebug.d(TAG, "addWatchedData " + netStatus);
    }

    void saveAndUpload() {
        try {
            sendResponseLog();
        } catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d(TAG, "发送失败: " + e.getMessage());
        }
    }

    private synchronized void sendResponseLog() throws Exception {
        NetStatus netStatusToUpload = unZipNetStatus();
        ResponseWatchDebug.d(TAG, "转换完类型");
        if (null == netStatusToUpload || ArrayUtils.isEmpty(netStatusToUpload.getMetrics()))
            return;

        //备份
        NetStatusCache netStatusCopy = (NetStatusCache) netStatus.clone();
        ResponseWatchDebug.d(TAG, "备份的netStatus ： " + netStatus.toString());
        ResponseWatchDebug.d(TAG, "备份的netStatusCopy： " + netStatusCopy.toString());

        ResponseWatchDebug.d(TAG, "真正开始发送 netStatusToUpload " + netStatusToUpload.toString());
        //发送网络请求的时候不能进行加锁，不然会导致发送的时候其他的监听无法监听，进行拥堵
        //有个问题，如果此网络请求很慢，拿到的 copy 不对,会导致重置的时候有两个重置，重置的结果不对
        Response<ResponseBody> response = ResponseApi
                .getClientApi()
                .collectMetrics(netStatusToUpload)
                .execute();

        //测试代码,测试当 sleep 的时候，继续发送请求，然后接口返回 ok 的时候是否会重置之前的
        //        Thread.sleep(5000);

        ResponseBody responseBody = response.body();
        if (null != responseBody && responseBody.isOk()) {
            //清空
            resetNetStatusCache(netStatusCopy);
            ResponseWatchDebug.d(TAG, "返回了我们的 Response,并重置 netStatus " + netStatus.toString());
        } else {
            if (null != responseBody) {
                ResponseWatchDebug.d(TAG, "失败 code " + responseBody.getErrorCode() + " message" + responseBody.getErrorMsg());
            } else {
                ResponseWatchDebug.d(TAG, "网络不通");
            }
        }
    }

    public void setTagInterface(TagInterface tagInterface) {
        this.tagInterface = tagInterface;
    }

    //解压 NetStatus
    private NetStatus unZipNetStatus() {
        //使用压缩的数据类型，不能对 netStatus 加锁，因为在上传的时候需要对 netStatus 仍然是可以进行写入的
        final Map<String, Long> statusMap = netStatus.statusMap;
        if (statusMap.isEmpty())
            return null;

        NetStatus.Tag tag = new NetStatus.Tag(tagInterface.getAppName(), tagInterface.getCityCode(), tagInterface.getDeviceId(),
                tagInterface.getDeviceId(), tagInterface.getDeviceId());

        List<NetStatus.Metric> metrics = new ArrayList<>();
        for (String key : statusMap.keySet()) {
            Long count = statusMap.get(key);
            if (null == count || 0L == count)
                continue;

            String[] keyValue = key.split(";");
            if (keyValue.length < 3)
                continue;

            String domain = keyValue[0];
            String uri = keyValue[1];
            int status = Integer.valueOf(keyValue[2]);
            NetStatus.Metric.Fields fields = new NetStatus.Metric.Fields(count);
            NetStatus.Metric.Tag tags = new NetStatus.Metric.Tag(domain, uri, status);
            NetStatus.Metric metric = new NetStatus.Metric(tags, fields);
            metrics.add(metric);
        }

        return new NetStatus(System.currentTimeMillis(), tag, metrics);
    }

    /**
     * 使用 netStatusCopy 重置内存中的 netStatus
     */
    private void resetNetStatusCache(NetStatusCache netStatusCopy) {
        if (null == netStatusCopy || netStatusCopy.statusMap.isEmpty()) {
            return;
        }

        Map<String, Long> netStatusZipsCopy = netStatusCopy.statusMap;
        Map<String, Long> netStatusZipsCache = netStatus.statusMap;

        for (Map.Entry<String, Long> entryCopy : netStatusZipsCopy.entrySet()) {
            for (Map.Entry<String, Long> entry : netStatusZipsCache.entrySet()) {
                String keyCopy = entryCopy.getKey();
                String key = entry.getKey();
                Long valueCopy = entryCopy.getValue();
                Long value = entry.getValue();
                if (null == keyCopy || null == key || null == valueCopy || null == value)
                    return;

                //相同的key，重置value
                if (keyCopy.equals(key)) {
                    entry.setValue(value - valueCopy);
                }
            }
        }

        syncSharedPreferences();
    }

    /**
     * 将内存中的 netStatus 同步到缓存中
     * 缓存时机：netStatus 改变的时候，也就是所有 netStatus 修改的时候进行同步
     */
    private synchronized void syncSharedPreferences() {
        executor.execute(() -> {
            try {
                netStatusPre.edit().putString(SPF_NETSTATUS, JSON.toJSONString(netStatus)).apply();
            } catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences save exception: " + e.getMessage());
            }
        });
    }
}
