package com.dada.response.watcher.watcher;

import com.dada.response.watcher.http.api.MetricsClient;
import com.dada.response.watcher.http.convert.FastJsonConverterFactory;
import com.dada.response.watcher.http.log.Retrofit2AndroidLog;
import com.dada.response.watcher.interceptor.HeaderInterceptor;
import com.dada.response.watcher.util.ResponseWatchDebug;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;

/**
 * Created by whh on 2019/6/20
 */
public class ResponseApi {

    //响应监听埋点
    private static final String METRICS_ONLINE = "https://metrics.imdada.cn/";
    private static final String METRICS_DEV = "http://metrics.ndev.imdada.cn/";

    private static MetricsClient metricsApi;

    private static Interceptor headerInterceptor;

    private static boolean isOnline = false;//是否是线上环境

    private static OkHttpClient provideMetricsOkHttpClient() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new Retrofit2AndroidLog("response-api"))
                .setLevel(ResponseWatchDebug.isDebug() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);

        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(interceptor);

        if (null != headerInterceptor) {
            builder.addInterceptor(headerInterceptor);
        }

        builder.addInterceptor(HeaderInterceptor.getInstance());
        return builder.build();
    }

    public static void setHeaderInterceptor(Interceptor headerInterceptor) {
        ResponseApi.headerInterceptor = headerInterceptor;
    }

    public static boolean isOnline() {
        return isOnline;
    }

    public static void setOnline(boolean isOnline) {
        ResponseApi.isOnline = isOnline;
    }

    private static String getMetricsHost() {
        if (isOnline)
            return METRICS_ONLINE;

        return METRICS_DEV;
    }

    static MetricsClient getClientApi() {
        if (null == metricsApi) {
            metricsApi = new Retrofit.Builder()
                    .baseUrl(getMetricsHost())
                    .client(provideMetricsOkHttpClient())
                    .addConverterFactory(FastJsonConverterFactory.create())
                    .build()
                    .create(MetricsClient.class);
        }
        return metricsApi;
    }

}
